/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.sql.SqlCommon;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.gridgain.internal.rbac.privileges.ObjectType;
import org.gridgain.internal.rbac.privileges.exception.IllegalPrivilegeSelectorException;
import org.jetbrains.annotations.Nullable;

public class Selector {
    private final ObjectType objectType;
    @Nullable
    private final String schemaName;
    @Nullable
    private final String objectName;

    private Selector(ObjectType objectType, @Nullable String schemaName, @Nullable String objectName) {
        this.objectType = objectType;
        this.schemaName = schemaName;
        this.objectName = objectName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Selector schema(String schema) {
        return Selector.builder().objectType(ObjectType.SCHEMA).schemaName(schema).build();
    }

    public static Selector table(String schema, String table) {
        return Selector.builder().objectType(ObjectType.TABLE).schemaName(schema).objectName(table).build();
    }

    public static Selector view(String schema, String view) {
        return Selector.builder().objectType(ObjectType.VIEW).schemaName(schema).objectName(view).build();
    }

    public static Selector sequence(String schema, String sequence) {
        return Selector.builder().objectType(ObjectType.SEQUENCE).schemaName(schema).objectName(sequence).build();
    }

    public static Selector sequence(String qualifiedName) {
        List<String> names = IgniteNameUtils.parseName(qualifiedName);
        String schema = names.size() > 1 ? names.get(0) : SqlCommon.DEFAULT_SCHEMA_NAME;
        String name = names.size() > 1 ? names.get(1) : names.get(0);
        return Selector.sequence(schema, name);
    }

    public static Selector deploymentUnit(String id) {
        return Selector.builder().objectType(ObjectType.DEPLOYMENT_UNIT).objectName(id).build();
    }

    public static Selector cluster() {
        return Selector.builder().objectType(ObjectType.CLUSTER).build();
    }

    public static Selector user(String username) {
        return Selector.builder().objectType(ObjectType.USER).objectName(username).build();
    }

    public ObjectType objectType() {
        return this.objectType;
    }

    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    @Nullable
    public String objectName() {
        return this.objectName;
    }

    @Nullable
    public String toRawString() {
        switch (this.objectType) {
            case CLUSTER: {
                return null;
            }
            case SCHEMA: {
                return this.schemaName;
            }
            case DEPLOYMENT_UNIT: 
            case USER: {
                return this.objectName;
            }
            case TABLE: 
            case VIEW: 
            case SEQUENCE: {
                return IgniteNameUtils.canonicalName(this.schemaName, this.objectName);
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.objectType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selector selector = (Selector)o;
        return this.objectType == selector.objectType && Objects.equals(this.schemaName, selector.schemaName) && Objects.equals(this.objectName, selector.objectName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectType, this.schemaName, this.objectName});
    }

    public String toString() {
        return "Selector{objectType=" + this.objectType + ", schemaName='" + this.schemaName + "', objectName='" + this.objectName + "'}";
    }

    public static class Builder {
        private ObjectType objectType;
        @Nullable
        private String schemaName;
        @Nullable
        private String objectName;

        public Builder objectType(ObjectType targetObjectType) {
            this.objectType = targetObjectType;
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder objectName(@Nullable String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Selector build() {
            this.validate();
            return new Selector(this.objectType, this.schemaName, this.objectName);
        }

        private void validate() {
            if (this.objectType == null) {
                throw new IllegalPrivilegeSelectorException("Object type should not be null");
            }
            if ((this.objectType == ObjectType.TABLE || this.objectType == ObjectType.VIEW) && this.objectName == null) {
                throw new IllegalPrivilegeSelectorException("Object name should not be null for " + this.objectType.name() + " object type");
            }
            if ((this.objectType == ObjectType.TABLE || this.objectType == ObjectType.VIEW || this.objectType == ObjectType.SCHEMA) && this.schemaName == null) {
                throw new IllegalPrivilegeSelectorException("Schema name should not be null for " + this.objectType.name() + " object type");
            }
            if ((this.objectType == ObjectType.DEPLOYMENT_UNIT || this.objectType == ObjectType.USER) && this.objectName == null) {
                throw new IllegalPrivilegeSelectorException("Object name should not be null for " + this.objectType.name() + " object type");
            }
        }
    }
}

