/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public class McpServerApplication {
    private static final IgniteLogger log = Loggers.forClass(McpServerApplication.class);
    private static final String SERVER_NAME = "gridgain-mcp";
    private static final String SERVER_VERSION = "1.0.0";

    public static void main(String[] args) {
        System.err.println("=== Starting GridGain 9 MCP Server ===");
        McpServerApplication.registerShutdownHook();
        McpServerApplication.startMcpServer();
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Shutting down GridGain MCP Server...", new Object[0]);
            try {
                log.info("Cleanup completed successfully", new Object[0]);
            }
            catch (Exception e) {
                log.error("Error during shutdown", (Throwable)e);
            }
        }, "mcp-shutdown-hook"));
        log.info("Shutdown hook registered", new Object[0]);
    }

    private static void startMcpServer() {
        log.info("Initializing MCP server with STDIO transport...", new Object[0]);
        StdioServerTransportProvider transport = new StdioServerTransportProvider(new ObjectMapper());
        McpServer.async(transport).serverInfo(SERVER_NAME, SERVER_VERSION).capabilities(McpServerApplication.buildServerCapabilities()).build();
        log.info("GridGain MCP Server starting now...", new Object[0]);
    }

    private static McpSchema.ServerCapabilities buildServerCapabilities() {
        return McpSchema.ServerCapabilities.builder().tools(true).logging().build();
    }
}

