/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.compute.JobExecutorType;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ComputeJobDataType;
import org.apache.ignite.internal.compute.SharedComputeUtils;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.marshalling.UnmarshallingException;
import org.jetbrains.annotations.Nullable;

public final class ClientComputeJobUnpacker {
    @Nullable
    public static Object unpackJobResult(ClientMessageUnpacker unpacker, @Nullable Marshaller<?, byte[]> marshaller, @Nullable Class<?> resultClass) {
        ComputeJobDataHolder holder = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller(unpacker);
        return SharedComputeUtils.unmarshalArgOrResult(holder, marshaller, resultClass);
    }

    @Nullable
    public static ComputeJobDataHolder unpackJobArgumentWithoutMarshaller(ClientMessageUnpacker unpacker) {
        if (unpacker.tryUnpackNil()) {
            return null;
        }
        int typeId = unpacker.unpackInt();
        ComputeJobDataType type = ComputeJobDataType.fromId(typeId);
        if (type == null) {
            throw new UnmarshallingException("Unsupported compute job type id: " + typeId);
        }
        return new ComputeJobDataHolder(type, unpacker.readBinary());
    }

    public static Job unpackJob(ClientMessageUnpacker unpacker, boolean enablePlatformJobs) {
        List<DeploymentUnit> deploymentUnits = unpacker.unpackDeploymentUnits();
        String jobClassName = unpacker.unpackString();
        JobExecutionOptions.Builder options = JobExecutionOptions.builder().priority(unpacker.unpackInt()).maxRetries(unpacker.unpackInt());
        if (enablePlatformJobs) {
            options.executorType(JobExecutorType.fromOrdinal(unpacker.unpackInt()));
        }
        ComputeJobDataHolder args = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller(unpacker);
        return new Job(deploymentUnits, jobClassName, options.build(), args);
    }

    @Nullable
    public static UUID unpackTaskId(ClientMessageUnpacker unpacker, boolean enableTaskId) {
        return enableTaskId ? unpacker.unpackUuidNullable() : null;
    }

    public static class Job {
        private final List<DeploymentUnit> deploymentUnits;
        private final String jobClassName;
        private final JobExecutionOptions options;
        @Nullable
        private final ComputeJobDataHolder args;

        private Job(List<DeploymentUnit> deploymentUnits, String jobClassName, JobExecutionOptions options, @Nullable ComputeJobDataHolder args) {
            this.deploymentUnits = deploymentUnits;
            this.jobClassName = jobClassName;
            this.options = options;
            this.args = args;
        }

        public List<DeploymentUnit> deploymentUnits() {
            return this.deploymentUnits;
        }

        public String jobClassName() {
            return this.jobClassName;
        }

        public JobExecutionOptions options() {
            return this.options;
        }

        @Nullable
        public ComputeJobDataHolder arg() {
            return this.args;
        }
    }
}

