/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.structure.map;

import java.util.List;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.internal.structure.descriptor.StructureDescriptor;
import org.gridgain.internal.structure.descriptor.StructureFieldDescriptor;
import org.gridgain.structure.MapConfiguration;
import org.gridgain.structure.StructureUtils;
import org.jetbrains.annotations.Nullable;

public class MapStructureDescriptor<K, V>
implements StructureDescriptor<K, V> {
    private final QualifiedName name;
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final StructureFieldDescriptor<K> keyColumn;
    private final StructureFieldDescriptor<V> valueColumn;
    @Nullable
    private final String distributionZone;
    @Nullable
    private final String storageProfile;
    private final List<StructureFieldDescriptor<?>> columns;

    public static <K, V> MapStructureDescriptor<K, V> of(MapConfiguration configuration) {
        return new MapStructureDescriptor<K, V>(configuration.getName(), StructureUtils.nativeOrByteArray((Class)configuration.getKeyClass()), StructureUtils.nativeOrByteArray((Class)configuration.getValueClass()), configuration.getDistributionZone(), configuration.getStorageProfile());
    }

    private MapStructureDescriptor(QualifiedName name, Class<K> keyClass, Class<V> valueClass, @Nullable String distributionZone, @Nullable String storageProfile) {
        this.name = name;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.distributionZone = distributionZone;
        this.storageProfile = storageProfile;
        this.keyColumn = new StructureFieldDescriptor("KEY", keyClass, StructureUtils.columnType(keyClass), false, true);
        this.valueColumn = new StructureFieldDescriptor("VAL", valueClass, StructureUtils.columnType(valueClass), true, false);
        this.columns = List.of(this.keyColumn, this.valueColumn);
    }

    public QualifiedName name() {
        return this.name;
    }

    public List<StructureFieldDescriptor<?>> columns() {
        return this.columns;
    }

    public Class<K> keyClass() {
        return this.keyClass;
    }

    public Class<V> valueClass() {
        return this.valueClass;
    }

    @Nullable
    public String distributionZone() {
        return this.distributionZone;
    }

    @Nullable
    public String storageProfile() {
        return this.storageProfile;
    }

    public StructureFieldDescriptor<K> keyColumn() {
        return this.keyColumn;
    }

    public StructureFieldDescriptor<V> valueColumn() {
        return this.valueColumn;
    }
}

