/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license.provider;

import com.typesafe.config.Config;
import java.net.http.HttpClient;
import java.nio.file.Path;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.provider.AwsLicenseProvider;
import org.gridgain.internal.license.provider.ConfigLicenseProvider;
import org.gridgain.internal.license.provider.GcpLicenseProvider;
import org.gridgain.internal.license.provider.LicenseProvider;
import org.jetbrains.annotations.Nullable;

public class LicenseProviderFactory {
    private final LicenseProvider awsLicenseProvider;
    private final LicenseProvider gcpLicenseProvider;

    public LicenseProviderFactory(Path configPath) {
        this.awsLicenseProvider = new AwsLicenseProvider(configPath);
        this.gcpLicenseProvider = new GcpLicenseProvider(HttpClient.newBuilder().build(), configPath);
    }

    public LicenseProvider getAvailableLicenseProvider(@Nullable Config clusterConfig) {
        ConfigLicenseProvider configLicenseProvider = new ConfigLicenseProvider(clusterConfig);
        if (clusterConfig != null && configLicenseProvider.isAvailable()) {
            return configLicenseProvider;
        }
        if (this.awsLicenseProvider.isAvailable()) {
            return this.awsLicenseProvider;
        }
        if (this.gcpLicenseProvider.isAvailable()) {
            return this.gcpLicenseProvider;
        }
        throw new LicenseViolationException("No available license provider. Check logs for details.");
    }

    public boolean isCloudLicenseAvailable() {
        return this.awsLicenseProvider.isAvailable() || this.gcpLicenseProvider.isAvailable();
    }
}

