/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.properties.IgniteProperties;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseAttributesCollector;
import org.gridgain.internal.license.LicenseViolationInfo;

public abstract class LicenseLimitChecker<T> {
    private static final LicenseLimitChecker<Integer> MAX_CORES = new LicenseLimitChecker<Integer>(HoconLicenseField.MAX_CORES){

        @Override
        void check(LicenseViolationInfo violationInfo, Collection<LogicalNode> nodes, Integer maxCores) {
            int totalCores = LicenseAttributesCollector.totalCpus(nodes);
            if (maxCores > 0 && maxCores < totalCores) {
                violationInfo.addViolation("maxCores", totalCores, maxCores, String.format("Maximum number of cores is exceeded (%d/%d).", totalCores, maxCores));
            }
        }
    };
    private static final LicenseLimitChecker<Integer> MAX_NODES = new LicenseLimitChecker<Integer>(HoconLicenseField.MAX_NODES){

        @Override
        void check(LicenseViolationInfo violationInfo, Collection<LogicalNode> nodes, Integer maxNodes) {
            int nodeCount = nodes.size();
            if (maxNodes > 0 && maxNodes < nodeCount) {
                violationInfo.addViolation("maxNodes", nodeCount, maxNodes, String.format("Maximum number of nodes is exceeded (%d/%d).", nodeCount, maxNodes));
            }
        }
    };
    private static final LicenseLimitChecker<Integer> MAX_HOSTS = new LicenseLimitChecker<Integer>(HoconLicenseField.MAX_HOSTS){

        @Override
        void check(LicenseViolationInfo violationInfo, Collection<LogicalNode> nodes, Integer maxHosts) {
            int hostCount = LicenseAttributesCollector.neighborhood(nodes).size();
            if (maxHosts > 0 && maxHosts < hostCount) {
                violationInfo.addViolation("maxHosts", hostCount, maxHosts, String.format("Maximum number of hosts is exceeded (%d/%d).", hostCount, maxHosts));
            }
        }
    };
    private static final LicenseLimitChecker<Long> MAX_OFFHEAP_SIZE = new LicenseLimitChecker<Long>(HoconLicenseField.MAX_OFFHEAP_SIZE){

        @Override
        void check(LicenseViolationInfo violationInfo, Collection<LogicalNode> nodes, Long maxOffheapSize) {
            long totalOffheap = LicenseAttributesCollector.offheapSize(nodes);
            if (maxOffheapSize > 0L && maxOffheapSize < totalOffheap) {
                violationInfo.addViolation("maxOffHeapSize", totalOffheap, maxOffheapSize, String.format("Maximum cluster off-heap size is exceeded (%d/%d).", totalOffheap, maxOffheapSize));
            }
        }
    };
    private static final LicenseLimitChecker<Long> MAX_HEAP_SIZE = new LicenseLimitChecker<Long>(HoconLicenseField.MAX_HEAP_SIZE){

        @Override
        void check(LicenseViolationInfo violationInfo, Collection<LogicalNode> nodes, Long maxHeapSize) {
            long totalHeap = LicenseAttributesCollector.heapSize(nodes);
            if (maxHeapSize > 0L && maxHeapSize < totalHeap) {
                violationInfo.addViolation("maxHeapSize", totalHeap, maxHeapSize, String.format("Maximum cluster heap size is exceeded (%d/%d).", totalHeap, maxHeapSize));
            }
        }
    };
    private static final LicenseLimitChecker<Long> MAX_RAM_SIZE = new LicenseLimitChecker<Long>(HoconLicenseField.MAX_RAM_SIZE){

        @Override
        void check(LicenseViolationInfo violationInfoHolder, Collection<LogicalNode> nodes, Long maxRamSize) {
            long totalRam = LicenseAttributesCollector.hostRamSize(nodes);
            if (maxRamSize > 0L && maxRamSize < totalRam) {
                violationInfoHolder.addViolation("maxHostRamSize", totalRam, maxRamSize, String.format("Maximum cluster RAM size is exceeded (%d/%d).", totalRam, maxRamSize));
            }
        }
    };
    private static final LicenseLimitChecker<String> RELEASE_TYPE = new LicenseLimitChecker<String>(HoconLicenseField.RELEASE_TYPE){

        @Override
        void check(LicenseViolationInfo violationInfoHolder, Collection<LogicalNode> nodes, String licenseReleaseType) {
            String localNodeReleaseType = IgniteProperties.get((String)"ignite.release.type");
            boolean isLicenseAllowPrivateRelease = "private".equalsIgnoreCase(licenseReleaseType);
            if (isLicenseAllowPrivateRelease) {
                return;
            }
            boolean isLocalNodePrivateRelease = "private".equalsIgnoreCase(localNodeReleaseType);
            if (isLocalNodePrivateRelease) {
                violationInfoHolder.addViolation("releaseType", localNodeReleaseType, licenseReleaseType, "A license for a private version is required. The provided license is only applicable for public versions and cannot be used with a private version.");
            }
        }
    };
    private static final LicenseLimitChecker<Long> MAX_DISK_SIZE = new LicenseLimitChecker<Long>(HoconLicenseField.MAX_DISK_SIZE){

        @Override
        void check(LicenseViolationInfo violationInfoHolder, Collection<LogicalNode> nodes, Long maxDiskSize) {
            long totalDiskSize = LicenseAttributesCollector.onDiskSize(nodes);
            if (maxDiskSize > 0L && maxDiskSize < totalDiskSize) {
                violationInfoHolder.addViolation("maxOnDiskSize", totalDiskSize, maxDiskSize, String.format("Maximum cluster disk size is exceeded (%d/%d).", totalDiskSize, maxDiskSize));
            }
        }
    };
    private static final List<LicenseLimitChecker<?>> ALL_CHECKERS = List.of(MAX_CORES, MAX_NODES, MAX_HOSTS, MAX_OFFHEAP_SIZE, MAX_HEAP_SIZE, MAX_RAM_SIZE, RELEASE_TYPE, MAX_DISK_SIZE);
    private final HoconLicenseField<T> field;

    LicenseLimitChecker(HoconLicenseField<T> field) {
        this.field = field;
    }

    abstract void check(LicenseViolationInfo var1, Collection<LogicalNode> var2, T var3);

    public void check(License license, LicenseViolationInfo violationInfo, Collection<LogicalNode> nodes) {
        assert (nodes != null);
        Object licenseField = license.field(this.field);
        if (licenseField != null) {
            this.check(violationInfo, nodes, licenseField);
        }
    }

    public static void checkAll(License license, LicenseViolationInfo violationInfo, Collection<LogicalNode> nodes) {
        for (LicenseLimitChecker<?> checker : ALL_CHECKERS) {
            checker.check(license, violationInfo, nodes);
        }
    }
}

