/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license.provider;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigUtil;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.license.LicenseWithSignature;
import org.gridgain.internal.license.configuration.LicenseExtensionConfiguration;
import org.gridgain.internal.license.provider.LicenseProvider;

public class ConfigLicenseProvider
implements LicenseProvider {
    private static final IgniteLogger LOG = Loggers.forClass(ConfigLicenseProvider.class);
    private static final String LICENSE_PATH = ConfigUtil.joinPath((String[])new String[]{LicenseExtensionConfiguration.KEY.key(), "license"});
    private final Config config;

    public ConfigLicenseProvider(Config config) {
        this.config = config;
    }

    @Override
    public boolean isAvailable() {
        boolean hasPath = this.config.hasPath(LICENSE_PATH);
        LOG.info("Config path found {}, path: {}", new Object[]{hasPath, LICENSE_PATH});
        return hasPath;
    }

    @Override
    public LicenseWithSignature getLicense() {
        Config licenseConfig = this.config.getConfig(LICENSE_PATH);
        return LicenseWithSignature.parseLicense(licenseConfig);
    }

    @Override
    public boolean isCloudLicense() {
        return false;
    }
}

