/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class LicenseViolationInfo {
    public static final String LICENSE_VIOLATION_MESSAGE_PREFIX = "License violation detected:";
    private final Collection<LicenseFieldViolationInfo> violations = new ArrayList<LicenseFieldViolationInfo>();

    void addViolation(String name, @Nullable Object value, @Nullable Object bound, String errorMessage) {
        this.violations.add(new LicenseFieldViolationInfo(name, value, bound, errorMessage));
    }

    void addViolation(String name, @Nullable Object value, String errorMessage) {
        this.violations.add(new LicenseFieldViolationInfo(name, value, null, errorMessage));
    }

    String formatViolationMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(LICENSE_VIOLATION_MESSAGE_PREFIX).append(System.lineSeparator());
        int cnt = 0;
        for (LicenseFieldViolationInfo msg : this.violations) {
            sb.append(msg.errorMessage);
            if (++cnt >= this.violations.size()) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    Collection<LicenseFieldViolationInfo> getViolations() {
        return this.violations;
    }

    static final class LicenseFieldViolationInfo {
        private final String name;
        @Nullable
        private final Object bound;
        @Nullable
        private final Object value;
        private final String errorMessage;

        private LicenseFieldViolationInfo(String name, @Nullable Object value, @Nullable Object bound, String errorMessage) {
            this.name = name;
            this.value = value;
            this.bound = bound;
            this.errorMessage = errorMessage;
        }

        String name() {
            return this.name;
        }

        @Nullable
        Object bound() {
            return this.bound;
        }

        @Nullable
        Object value() {
            return this.value;
        }

        String errorMessage() {
            return this.errorMessage;
        }
    }
}

