/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.license.CloudLicense;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.LicenseWithSignature;
import org.gridgain.internal.license.provider.CloudProduct;
import org.gridgain.internal.license.provider.LicenseProvider;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.internal.util.EC2MetadataUtils;

public class AwsLicenseProvider
implements LicenseProvider {
    private static final IgniteLogger LOG = Loggers.forClass(AwsLicenseProvider.class);
    private static final String AWS_PRODUCT_MAPPING_FILENAME = "aws-marketplace-map.json";
    private final Path mappingFilePath;
    private final LicenseWithSignature license;

    public AwsLicenseProvider(Path configPath) {
        String awsMappingFilePath = IgniteSystemProperties.getString((String)"GG_AWS_MAPPING_FILE_PATH");
        if (awsMappingFilePath != null && !awsMappingFilePath.isEmpty()) {
            this.mappingFilePath = Path.of(awsMappingFilePath, new String[0]);
            LOG.info("Using AWS mapping file path: {}", new Object[]{awsMappingFilePath});
        } else {
            this.mappingFilePath = configPath.resolveSibling(AWS_PRODUCT_MAPPING_FILENAME);
            LOG.info("Using AWS mapping file path from config sibling: {}", new Object[]{this.mappingFilePath});
        }
        this.license = this.getLicenseInternal();
    }

    @Override
    public boolean isAvailable() {
        return this.license != null;
    }

    @Override
    public LicenseWithSignature getLicense() {
        return this.license;
    }

    @Override
    public boolean isCloudLicense() {
        return true;
    }

    @Nullable
    private LicenseWithSignature getLicenseInternal() {
        if (!Files.exists(this.mappingFilePath, new LinkOption[0])) {
            return null;
        }
        try {
            String fileContent = Files.readString(this.mappingFilePath);
            List products = (List)new ObjectMapper().readValue(fileContent, (TypeReference)new TypeReference<List<CloudProduct>>(){});
            String marketplaceProductCode = this.getValidMarketplaceProductCode();
            LOG.info("Using marketplace product code: {}", new Object[]{marketplaceProductCode});
            CloudProduct matchingProduct = this.findMatchingProduct(products, marketplaceProductCode);
            CloudLicense newLicense = new CloudLicense(matchingProduct);
            return LicenseWithSignature.fromLicense(newLicense);
        }
        catch (LicenseViolationException e) {
            LOG.info("AWS License is not available: {}", (Throwable)e);
            return null;
        }
        catch (SdkClientException e) {
            LOG.info("AWS License is not available: Failed to get license info from AWS: {}", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.info("AWS License is not available: Cannot parse AWS mapping file: {}", (Throwable)e);
            return null;
        }
    }

    private String getValidMarketplaceProductCode() {
        EC2MetadataUtils.InstanceInfo instanceInfo = EC2MetadataUtils.getInstanceInfo();
        Object[] marketplaceProductCodes = instanceInfo.getMarketplaceProductCodes();
        LOG.info("Marketplace product codes: {}", new Object[]{Arrays.toString(marketplaceProductCodes)});
        if (marketplaceProductCodes == null || marketplaceProductCodes.length == 0) {
            throw new LicenseViolationException("Marketplace product codes are missing");
        }
        if (marketplaceProductCodes.length > 1) {
            throw new LicenseViolationException("More than one marketplace product code has been specified");
        }
        return marketplaceProductCodes[0];
    }

    private CloudProduct findMatchingProduct(List<CloudProduct> productList, String marketplaceProductCode) {
        return productList.stream().filter(product -> product.getProductCode().equals(marketplaceProductCode)).findFirst().orElseThrow(() -> new LicenseViolationException("Unknown product code '" + marketplaceProductCode + "' has been provided!"));
    }
}

