/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.LicenseField;
import org.gridgain.internal.license.MissingRequiredFeaturesException;
import org.gridgain.internal.license.event.LicenseUpdateEventParameters;

public class LicenseFeatureCheckerImpl
implements LicenseFeatureChecker,
EventListener<LicenseUpdateEventParameters> {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Set<LicenseFeature> enabledFeatures = EnumSet.noneOf(LicenseFeature.class);

    public Set<LicenseFeature> enabledFeatures() {
        this.readWriteLock.readLock().lock();
        try {
            Set<LicenseFeature> set = Set.copyOf(this.enabledFeatures);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public CompletableFuture<Boolean> notify(LicenseUpdateEventParameters parameters) {
        this.readWriteLock.writeLock().lock();
        try {
            Set licenseFeatures = (Set)parameters.license().field((LicenseField)HoconLicenseField.FEATURES);
            this.enabledFeatures = licenseFeatures == null ? Set.of() : licenseFeatures;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return CompletableFutures.falseCompletedFuture();
    }

    public void checkFeature(LicenseFeature feature) {
        this.readWriteLock.readLock().lock();
        try {
            if (!this.enabledFeatures.contains(feature)) {
                throw new MissingRequiredFeaturesException(Collections.singleton(feature));
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllFeature(Set<LicenseFeature> features) {
        this.readWriteLock.readLock().lock();
        try {
            EnumSet<LicenseFeature> deniedFeatures = EnumSet.noneOf(LicenseFeature.class);
            for (LicenseFeature reqFeature : features) {
                if (this.enabledFeatures.contains(reqFeature)) continue;
                deniedFeatures.add(reqFeature);
            }
            if (!deniedFeatures.isEmpty()) {
                throw new MissingRequiredFeaturesException(deniedFeatures);
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void checkAnyFeature(Set<LicenseFeature> features) {
        this.readWriteLock.readLock().lock();
        try {
            for (LicenseFeature reqFeature : features) {
                if (!this.enabledFeatures.contains(reqFeature)) continue;
                return;
            }
            throw new MissingRequiredFeaturesException(features);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

