/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;
import org.gridgain.internal.license.configuration.LicenseExtensionConfiguration;
import org.gridgain.internal.license.configuration.LicenseExtensionView;
import org.gridgain.internal.license.configuration.LicenseView;
import org.gridgain.internal.license.configuration.validator.HasLicenseFeature;
import org.gridgain.internal.license.event.LicenseUpdateEventParameters;

public class HasLicenseFeatureValidator
implements Validator<HasLicenseFeature, Object>,
EventListener<LicenseUpdateEventParameters> {
    private final LicenseFeatureChecker licenseFeatureChecker;
    private boolean licenseApplied;

    public HasLicenseFeatureValidator(LicenseFeatureChecker licenseFeatureChecker) {
        this.licenseFeatureChecker = licenseFeatureChecker;
    }

    public void validate(HasLicenseFeature annotation, ValidationContext<Object> ctx) {
        block11: {
            Set<LicenseFeature> requiredFeatures = Set.of(annotation.features());
            if (this.licenseApplied) {
                try {
                    if (annotation.requireAll()) {
                        this.licenseFeatureChecker.checkAllFeature(requiredFeatures);
                        break block11;
                    }
                    this.licenseFeatureChecker.checkAnyFeature(requiredFeatures);
                }
                catch (MissingRequiredFeaturesException e) {
                    ctx.addIssue(new ValidationIssue(ctx.currentKey(), e.getMessage()));
                }
            } else {
                LicenseView license = ((LicenseExtensionView)ctx.getNewRoot(LicenseExtensionConfiguration.KEY)).license();
                Config licenseObj = ConfigFactory.parseString((String)license.content());
                Set actualFeatures = (Set)HoconLicenseField.FEATURES.readFrom((Object)licenseObj);
                if (actualFeatures == null) {
                    ctx.addIssue(new ValidationIssue(ctx.currentKey(), MissingRequiredFeaturesException.message(requiredFeatures)));
                } else if (annotation.requireAll()) {
                    if (!actualFeatures.containsAll(requiredFeatures)) {
                        ctx.addIssue(new ValidationIssue(ctx.currentKey(), MissingRequiredFeaturesException.message(requiredFeatures)));
                    }
                } else if (actualFeatures.stream().noneMatch(requiredFeatures::contains)) {
                    ctx.addIssue(new ValidationIssue(ctx.currentKey(), MissingRequiredFeaturesException.message(requiredFeatures)));
                }
            }
        }
    }

    public CompletableFuture<Boolean> notify(LicenseUpdateEventParameters parameters) {
        this.licenseApplied = true;
        return CompletableFutures.falseCompletedFuture();
    }
}

