/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.ignite.internal.util.StringUtils;
import org.gridgain.internal.license.InvalidSignatureException;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseField;
import org.gridgain.internal.license.LicenseValidator;
import org.gridgain.internal.license.LicenseViolationException;
import org.jetbrains.annotations.VisibleForTesting;

class HoconLicense
implements License {
    private static final String PUBLIC_KEY_FILE_NAME = "gg9license.cer";
    private static final String SIGN_ALG = "SHA256withDSA";
    private static final PublicKey PUBLIC_KEY = HoconLicense.readPublicKeyFromResources();
    private final Config licenseObj;
    private boolean isJson;

    HoconLicense(String content, boolean isJson) {
        if (StringUtils.nullOrBlank((String)content)) {
            throw new LicenseViolationException("License parsing error: license is empty");
        }
        try {
            this.licenseObj = ConfigFactory.parseString((String)content);
        }
        catch (ConfigException.Parse e) {
            throw new LicenseViolationException("License parsing error: " + e.getMessage(), (Throwable)e);
        }
        this.isJson = isJson;
    }

    HoconLicense(Config hoconConfig) {
        this.licenseObj = hoconConfig;
    }

    public <T> T field(LicenseField<T> field) {
        return (T)field.readFrom((Object)this.licenseObj);
    }

    public boolean verifySignature(byte[] expectedSignature) {
        try {
            Signature signature = this.signature();
            Signature fallbackSignature = this.fallbackSignature();
            return signature.verify(expectedSignature) || fallbackSignature.verify(expectedSignature);
        }
        catch (GeneralSecurityException e) {
            throw new InvalidSignatureException((Throwable)e);
        }
    }

    public Config config() {
        return this.licenseObj.withoutPath("signatures");
    }

    private Signature signature() throws GeneralSecurityException {
        Signature signature = Signature.getInstance(SIGN_ALG);
        signature.initVerify(PUBLIC_KEY);
        signature.update(HoconLicense.canonicalRepresentation(this.licenseObj, this.isJson).getBytes(StandardCharsets.UTF_8));
        return signature;
    }

    private Signature fallbackSignature() throws GeneralSecurityException {
        Signature signature = Signature.getInstance(SIGN_ALG);
        signature.initVerify(PUBLIC_KEY);
        signature.update(HoconLicense.canonicalRepresentation(this.licenseObj, false).getBytes(StandardCharsets.UTF_8));
        return signature;
    }

    private static PublicKey readPublicKeyFromResources() {
        PublicKey publicKey;
        block10: {
            InputStream in = LicenseValidator.class.getClassLoader().getResourceAsStream(PUBLIC_KEY_FILE_NAME);
            try {
                if (in == null) {
                    throw new LicenseViolationException("Certificate not found.");
                }
                byte[] cert = in.readAllBytes();
                publicKey = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(cert)).getPublicKey();
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CertificateException e) {
                    throw new LicenseViolationException("Invalid X509 certificate.", (Throwable)e);
                }
                catch (IOException e) {
                    throw new LicenseViolationException("Problem with reading a certificate.", (Throwable)e);
                }
            }
            in.close();
        }
        return publicKey;
    }

    @VisibleForTesting
    static String canonicalRepresentation(Config config, boolean isJson) {
        return config.root().render(ConfigRenderOptions.concise().setJson(isJson));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoconLicense that = (HoconLicense)o;
        return this.licenseObj.equals(that.licenseObj);
    }

    public int hashCode() {
        return this.licenseObj.hashCode();
    }
}

