/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.license.LicenseValidator;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.LicenseViolationInfo;
import org.gridgain.internal.license.LicenseWithSignature;
import org.gridgain.internal.license.configuration.LicenseView;
import org.gridgain.internal.license.configuration.validator.License;

public class LicenseContentValidatorImpl
implements Validator<License, LicenseView> {
    public static final LicenseContentValidatorImpl INSTANCE = new LicenseContentValidatorImpl();
    private static final IgniteLogger LOG = Loggers.forClass(LicenseContentValidatorImpl.class);

    public void validate(License annotation, ValidationContext<LicenseView> ctx) {
        LicenseView newValue = (LicenseView)ctx.getNewValue();
        if (newValue.content().isBlank() && newValue.signature().isBlank()) {
            return;
        }
        List<ValidationIssue> issues = LicenseContentValidatorImpl.verifyLicense(ctx.currentKey(), () -> LicenseWithSignature.parseLicense(newValue.content(), newValue.signature()));
        if (issues.isEmpty()) {
            return;
        }
        String licenseOverridePath = IgniteSystemProperties.getString((String)"GG_LICENSE_OVERRIDE");
        if (licenseOverridePath != null) {
            issues.clear();
            try {
                String license = Files.readString(Path.of(licenseOverridePath, new String[0]));
                LOG.info("Overriding license from file \"{}\"", new Object[]{licenseOverridePath});
                issues = LicenseContentValidatorImpl.verifyLicense(ctx.currentKey(), () -> LicenseWithSignature.parseLicense(license));
            }
            catch (IOException e) {
                String message = IgniteStringFormatter.format((String)"Failed to read license override file \"{}\"", (Object[])new Object[]{licenseOverridePath});
                LOG.error(message, (Throwable)e);
                issues.add(new ValidationIssue(ctx.currentKey(), message));
            }
        }
        issues.forEach(arg_0 -> ctx.addIssue(arg_0));
    }

    private static List<ValidationIssue> verifyLicense(String currentKey, Supplier<LicenseWithSignature> licenseSupplier) {
        ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>();
        try {
            LicenseViolationInfo violationInfo = LicenseValidator.verifyLicense(licenseSupplier.get());
            for (LicenseViolationInfo.LicenseFieldViolationInfo info : violationInfo.getViolations()) {
                issues.add(new ValidationIssue(currentKey, info.errorMessage()));
            }
        }
        catch (LicenseViolationException e) {
            issues.add(new ValidationIssue(currentKey, e.getMessage()));
        }
        return issues;
    }
}

