/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.cluster.management.NodeAttributesProvider;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileView;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileView;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbProfileView;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.Lazy;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.raft.jraft.util.Utils;

public class LicenseAttributesCollector
implements NodeAttributesProvider {
    private static final IgniteLogger LOG = Loggers.forClass(LicenseAttributesCollector.class);
    private static final Lazy<Collection<String>> ALL_LOCAL_MACS = new Lazy(LicenseAttributesCollector::collectAllLocalMacs);
    private static final String NODE_ATTRIBUTES_LIST_SEPARATOR = ",";
    public static final String ATTR_MACS = "node-macs";
    public static final String ATTR_JVM_PID = "jvm-pid";
    public static final String ATTR_AVAILABLE_PROCESSORS = "node-available-processors";
    public static final String ATTR_PHY_RAM = "node-physical-ram";
    public static final String ATTR_ONHEAP_INIT_SIZE = "node-heap-init-size";
    public static final String ATTR_ONHEAP_MAX_SIZE = "node-heap-max-size";
    public static final String ATTR_OFFHEAP_SIZE = "node-off-heap-size";
    public static final String ATTR_ONDISK_SIZE = "node-on-disk-size";
    private OperatingSystemMXBean operatingSystemMxBean;
    private StorageConfiguration storageConfiguration;
    private PersistentPageMemoryStorageEngine persistentPageMemoryStorageEngine;
    private MemoryMXBean memoryMxBean;

    public LicenseAttributesCollector(StorageConfiguration storageConfiguration, PersistentPageMemoryStorageEngine persistentPageMemoryStorageEngine, MemoryMXBean memoryMxBean, OperatingSystemMXBean operatingSystemMxBean) {
        this.memoryMxBean = memoryMxBean;
        this.storageConfiguration = storageConfiguration;
        this.operatingSystemMxBean = operatingSystemMxBean;
        this.persistentPageMemoryStorageEngine = persistentPageMemoryStorageEngine;
    }

    public Map<String, String> nodeAttributes() {
        MemoryUsage heapMemoryUsage = this.memoryMxBean.getHeapMemoryUsage();
        return Map.of(ATTR_AVAILABLE_PROCESSORS, Integer.toString(this.operatingSystemMxBean.getAvailableProcessors()), ATTR_MACS, String.join((CharSequence)NODE_ATTRIBUTES_LIST_SEPARATOR, (Iterable)ALL_LOCAL_MACS.get()), ATTR_JVM_PID, Long.toString(Utils.getProcessId((long)ThreadLocalRandom.current().nextLong(10000L, Integer.MAX_VALUE))), ATTR_PHY_RAM, Long.toString(IgniteUtils.getTotalMemoryAvailable()), ATTR_OFFHEAP_SIZE, Long.toString(LicenseAttributesCollector.requiredOffheap(this.storageConfiguration)), ATTR_ONHEAP_INIT_SIZE, Long.toString(heapMemoryUsage.getInit()), ATTR_ONHEAP_MAX_SIZE, Long.toString(heapMemoryUsage.getMax()), ATTR_ONDISK_SIZE, Long.toString(this.persistentPageMemoryStorageEngine.getUsedBytes()));
    }

    static int totalCpus(Collection<LogicalNode> nodes) {
        assert (nodes != null);
        int sum = 0;
        for (Collection<LogicalNode> hood : LicenseAttributesCollector.neighborhood(nodes).values()) {
            LogicalNode first = (LogicalNode)CollectionUtils.first(hood);
            if (first == null) continue;
            sum += LicenseAttributesCollector.integerAttribute(first, ATTR_AVAILABLE_PROCESSORS, 0);
        }
        return sum;
    }

    static long heapSize(Collection<LogicalNode> nodes) {
        long totalOnheap = 0L;
        for (LogicalNode n : LicenseAttributesCollector.nodesPerJvm(nodes)) {
            long initializedSize = LicenseAttributesCollector.longAttribute(n, ATTR_ONHEAP_INIT_SIZE, 0L);
            long maxSize = LicenseAttributesCollector.longAttribute(n, ATTR_ONHEAP_MAX_SIZE, 0L);
            totalOnheap += Math.max(initializedSize, maxSize);
        }
        return totalOnheap;
    }

    static long offheapSize(Iterable<LogicalNode> nodes) {
        long totalOffheap = 0L;
        for (LogicalNode n : LicenseAttributesCollector.nodesPerJvm(nodes)) {
            totalOffheap += LicenseAttributesCollector.longAttribute(n, ATTR_OFFHEAP_SIZE, 0L);
        }
        return totalOffheap;
    }

    static long hostRamSize(Iterable<LogicalNode> nodes) {
        long totalHostRamSize = 0L;
        for (Collection<LogicalNode> nodesPerHost : LicenseAttributesCollector.neighborhood(nodes).values()) {
            LogicalNode first = (LogicalNode)CollectionUtils.first(nodesPerHost);
            if (first == null) continue;
            totalHostRamSize += LicenseAttributesCollector.longAttribute(first, ATTR_PHY_RAM, 0L);
        }
        return totalHostRamSize;
    }

    static long onDiskSize(Iterable<LogicalNode> nodes) {
        long totalDiskSize = 0L;
        for (LogicalNode n : nodes) {
            totalDiskSize += LicenseAttributesCollector.longAttribute(n, ATTR_ONDISK_SIZE, 0L);
        }
        return totalDiskSize;
    }

    static long requiredOffheap(StorageConfiguration storageConfiguration) {
        return ((NamedListView)storageConfiguration.profiles().value()).stream().mapToLong(view -> {
            if (view instanceof PersistentPageMemoryProfileView) {
                return ((PersistentPageMemoryProfileView)view).sizeBytes();
            }
            if (view instanceof VolatilePageMemoryProfileView) {
                return ((VolatilePageMemoryProfileView)view).maxSizeBytes();
            }
            if (view instanceof RocksDbProfileView) {
                return ((RocksDbProfileView)view).sizeBytes();
            }
            LOG.warn("Failed to get required off-heap memory for storage profile: " + view.name(), new Object[0]);
            return 0L;
        }).sum();
    }

    private static Collection<String> collectAllLocalMacs() {
        TreeSet macs = new TreeSet();
        try {
            Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
            itfs.asIterator().forEachRemaining(itf -> {
                try {
                    byte[] hwAddr = itf.getHardwareAddress();
                    if (hwAddr != null && hwAddr.length > 0) {
                        String mac = StringUtils.toHexString((byte[])hwAddr);
                        macs.add(mac);
                    }
                }
                catch (SocketException ignore) {
                    LOG.warn("Unable to collect a hardware address (usually MAC) of the interface: " + itf.getDisplayName(), new Object[0]);
                }
            });
        }
        catch (SocketException ignore) {
            LOG.warn("Unable to collect a list of all local enabled MACs known to this JVM.", new Object[0]);
            return Collections.emptyList();
        }
        return Collections.unmodifiableNavigableSet(macs);
    }

    static Map<String, Collection<LogicalNode>> neighborhood(Iterable<LogicalNode> nodes) {
        HashMap<String, Collection<LogicalNode>> map = new HashMap<String, Collection<LogicalNode>>();
        for (LogicalNode n : nodes) {
            String macs = LicenseAttributesCollector.attribute(n, ATTR_MACS);
            assert (macs != null) : "Missing MACs attribute: " + n;
            Collection neighbors = map.computeIfAbsent(macs, k -> new ArrayList(2));
            neighbors.add(n);
        }
        return map;
    }

    static Iterable<LogicalNode> nodesPerJvm(Iterable<LogicalNode> nodes) {
        HashMap<JvmKey, LogicalNode> grpMap = new HashMap<JvmKey, LogicalNode>();
        for (LogicalNode n : nodes) {
            grpMap.putIfAbsent(new JvmKey(LicenseAttributesCollector.longAttribute(n, ATTR_JVM_PID, 0L), LicenseAttributesCollector.attribute(n, ATTR_MACS)), n);
        }
        return grpMap.values();
    }

    private static String attribute(LogicalNode node, String attr) {
        String value = (String)node.systemAttributes().get(attr);
        assert (value != null) : "Missing node attribute: " + attr;
        return value;
    }

    private static long longAttribute(LogicalNode node, String attr, long def) {
        String value = LicenseAttributesCollector.attribute(node, attr);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("Unable to parse the long node attribute '{}':{} - using the default value: {}.", new Object[]{attr, value, def});
            return def;
        }
    }

    private static int integerAttribute(LogicalNode node, String attr, int def) {
        String value = LicenseAttributesCollector.attribute(node, attr);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("Unable to parse the integer node attribute '{}':{} - using the default value: {}.", new Object[]{attr, value, def});
            return def;
        }
    }

    private static class JvmKey {
        long pid;
        String macs;

        JvmKey(long pid, String macs) {
            this.pid = pid;
            this.macs = macs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JvmKey jvmKey = (JvmKey)o;
            return this.pid == jvmKey.pid && Objects.equals(this.macs, jvmKey.macs);
        }

        public int hashCode() {
            return Objects.hash(this.pid, this.macs);
        }
    }
}

