/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license.provider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.license.CloudLicense;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.LicenseWithSignature;
import org.gridgain.internal.license.provider.AwsLicenseProvider;
import org.gridgain.internal.license.provider.CloudProduct;
import org.gridgain.internal.license.provider.GcpMetadataUrlProvider;
import org.gridgain.internal.license.provider.LicenseProvider;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.exception.SdkClientException;

public class GcpLicenseProvider
implements LicenseProvider {
    private static final IgniteLogger LOG = Loggers.forClass(AwsLicenseProvider.class);
    private static final String METADATA_FLAVOR_HEADER = "Metadata-Flavor";
    private static final String GOOGLE_FLAVOR = "Google";
    private static final String GCP_PRODUCT_MAPPING_FILENAME = "gcp-mapping.json";
    private final Path mappingFilePath;
    private final HttpClient httpClient;
    private final LicenseWithSignature license;

    public GcpLicenseProvider(HttpClient httpClient, Path configPath) {
        String gcpMappingFilePath = IgniteSystemProperties.getString((String)"GG_GCP_MAPPING_FILE_PATH");
        if (gcpMappingFilePath != null && !gcpMappingFilePath.isEmpty()) {
            this.mappingFilePath = Path.of(gcpMappingFilePath, new String[0]);
            LOG.info("Using GCP mapping file path from system property: {}", new Object[]{gcpMappingFilePath});
        } else {
            this.mappingFilePath = configPath.resolveSibling(GCP_PRODUCT_MAPPING_FILENAME);
            LOG.info("Using GCP mapping file path from config sibling: {}", new Object[]{this.mappingFilePath});
        }
        this.httpClient = httpClient;
        this.license = this.getLicenseInternal();
    }

    @Override
    public boolean isAvailable() {
        return this.license != null;
    }

    @Override
    public LicenseWithSignature getLicense() {
        return this.license;
    }

    @Override
    public boolean isCloudLicense() {
        return true;
    }

    @Nullable
    private LicenseWithSignature getLicenseInternal() {
        if (!Files.exists(this.mappingFilePath, new LinkOption[0])) {
            return null;
        }
        try {
            String fileContent = Files.readString(this.mappingFilePath);
            List products = (List)new ObjectMapper().readValue(fileContent, (TypeReference)new TypeReference<List<CloudProduct>>(){});
            List<String> marketplaceProductCodes = this.getProductCodes();
            LOG.info("Using marketplace product code: {}", new Object[]{marketplaceProductCodes});
            CloudProduct matchingProduct = this.findMatchingProduct(products, marketplaceProductCodes);
            CloudLicense newLicense = new CloudLicense(matchingProduct);
            return LicenseWithSignature.fromLicense(newLicense);
        }
        catch (LicenseViolationException e) {
            LOG.info("GCP License is not available: {}", (Throwable)e);
            return null;
        }
        catch (SdkClientException e) {
            LOG.info("GCP License is not available: Failed to get license info from GCP: {}", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.info("GCP License is not available: Cannot parse GCP mapping file: {}", (Throwable)e);
            return null;
        }
    }

    private List<String> getProductCodes() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(GcpMetadataUrlProvider.getProductCodeAttributeUrl())).header(METADATA_FLAVOR_HEADER, GOOGLE_FLAVOR).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String body = this.handleResponse(response);
            if (body == null || body.isBlank()) {
                throw new LicenseViolationException("Marketplace product codes are missing");
            }
            List licenses = (List)new ObjectMapper().readValue(body, (TypeReference)new TypeReference<List<GcpMetadataUrlProvider.GcpLicense>>(){});
            return licenses.stream().map(GcpMetadataUrlProvider.GcpLicense::getId).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new LicenseViolationException("Cannot get product codes: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new LicenseViolationException("Request was interrupted: " + e.getMessage(), (Throwable)e);
        }
    }

    private String handleResponse(HttpResponse<String> response) {
        int statusCode = response.statusCode();
        switch (statusCode) {
            case 200: {
                return response.body();
            }
            case 404: {
                throw new LicenseViolationException("Product codes attribute no available");
            }
        }
        throw new LicenseViolationException("Unexpected response code: " + statusCode + ", body: " + response.body());
    }

    private CloudProduct findMatchingProduct(List<CloudProduct> productList, List<String> marketplaceIds) {
        return productList.stream().filter(product -> marketplaceIds.contains(product.getProductCode())).findFirst().orElseThrow(() -> new LicenseViolationException("Unknown product codes '" + marketplaceIds + "' has been provided!"));
    }
}

