/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.InvalidSignatureException;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseField;
import org.gridgain.internal.license.provider.CloudProduct;
import org.jetbrains.annotations.Nullable;

public class CloudLicense
implements License {
    private static final IgniteLogger LOG = Loggers.forClass(CloudLicense.class);
    private final Set<LicenseFeature> features = new HashSet<LicenseFeature>();
    private final Config config;
    private final String productCode;

    public CloudLicense(CloudProduct product) {
        for (String feature : product.getFeatureSet()) {
            try {
                this.features.add(LicenseFeature.valueOf((String)feature));
            }
            catch (IllegalArgumentException e) {
                LOG.info("Unknown license feature: " + feature, new Object[0]);
            }
        }
        this.productCode = product.getProductCode();
        this.config = ConfigFactory.empty().withValue("id", ConfigValueFactory.fromAnyRef((Object)product.getProductCode())).withValue("features", (ConfigValue)ConfigValueFactory.fromIterable((Iterable)this.features.stream().map(Enum::name).collect(Collectors.toList())));
    }

    @Nullable
    public <T> T field(LicenseField<T> field) {
        if (HoconLicenseField.FEATURES.equals(field)) {
            return (T)this.features;
        }
        if (HoconLicenseField.ID.equals(field)) {
            return (T)this.productCode;
        }
        if (HoconLicenseField.START_DATE.equals(field)) {
            return (T)LocalDate.MIN;
        }
        if (HoconLicenseField.EXPIRE_DATE.equals(field)) {
            return (T)LocalDate.MAX;
        }
        return null;
    }

    public boolean verifySignature(byte[] expectedSignature) throws InvalidSignatureException {
        return true;
    }

    public Config config() {
        return this.config;
    }
}

