/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.util.Collection;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.systemview.api.ClusterSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.gridgain.internal.license.GridLicenseManager;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseField;

public class LicenseSystemViews {
    static SystemView<?> createLicenseSystemView(GridLicenseManager licenseManager) {
        Iterable viewData = () -> {
            License license = licenseManager.currentLicense();
            LicenseViewDescriptor systemView = new LicenseViewDescriptor((String)license.field((LicenseField)HoconLicenseField.ID), String.valueOf(license.field((LicenseField)HoconLicenseField.EDITION)), LicenseSystemViews.configObjectToString((ConfigObject)license.field((LicenseField)HoconLicenseField.INFOS)), LicenseSystemViews.configObjectToString((ConfigObject)license.field((LicenseField)HoconLicenseField.LIMITS)), LicenseSystemViews.collectionToString((Collection)license.field((LicenseField)HoconLicenseField.FEATURES)), (String)license.field((LicenseField)HoconLicenseField.RELEASE_TYPE));
            return Stream.of(systemView).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(viewData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("LICENSES")).addColumn("LICENSE_ID", NativeTypes.STRING, license -> license.id)).addColumn("LICENSE_EDITION", NativeTypes.STRING, license -> license.edition)).addColumn("LICENSE_COMMON_INFO", NativeTypes.STRING, license -> license.infos)).addColumn("LICENSE_LIMITS", NativeTypes.STRING, license -> license.limits)).addColumn("LICENSE_FEATURES", NativeTypes.STRING, license -> license.features)).addColumn("ID", NativeTypes.STRING, license -> license.id)).addColumn("EDITION", NativeTypes.STRING, license -> license.edition)).addColumn("COMMON_INFO", NativeTypes.STRING, license -> license.infos)).addColumn("LIMITS", NativeTypes.STRING, license -> license.limits)).addColumn("FEATURES", NativeTypes.STRING, license -> license.features)).addColumn("RELEASE_TYPE", NativeTypes.STRING, license -> license.releaseType)).dataProvider(viewDataPublisher)).build();
    }

    static String configObjectToString(ConfigObject object) {
        return object.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + ((ConfigValue)entry.getValue()).render()).sorted().collect(Collectors.joining(",\n"));
    }

    static String collectionToString(Collection<?> collection) {
        return collection.stream().map(Object::toString).sorted().collect(Collectors.joining(",\n"));
    }

    private static class LicenseViewDescriptor {
        private final String id;
        private final String edition;
        private final String infos;
        private final String limits;
        private final String features;
        private final String releaseType;

        LicenseViewDescriptor(String id, String edition, String infos, String limits, String features, String releaseType) {
            this.id = id;
            this.edition = edition;
            this.infos = infos;
            this.limits = limits;
            this.features = features;
            this.releaseType = releaseType;
        }
    }
}

