/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.gridgain.internal.license.LicenseValidator;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.LicenseViolationInfo;
import org.gridgain.internal.license.LicenseWithSignature;
import org.gridgain.internal.license.configuration.LicenseView;
import org.gridgain.internal.license.configuration.validator.License;

public class LicenseContentValidatorImpl
implements Validator<License, LicenseView> {
    public static final LicenseContentValidatorImpl INSTANCE = new LicenseContentValidatorImpl();

    public void validate(License annotation, ValidationContext<LicenseView> ctx) {
        LicenseWithSignature licenseWithSignature;
        LicenseView newValue = (LicenseView)ctx.getNewValue();
        if (newValue.content().isBlank() && newValue.signature().isBlank()) {
            return;
        }
        try {
            licenseWithSignature = LicenseWithSignature.parseLicense(newValue.content(), newValue.signature());
        }
        catch (LicenseViolationException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), e.getMessage()));
            return;
        }
        LicenseViolationInfo violationInfo = LicenseValidator.verifyLicense(licenseWithSignature.license(), licenseWithSignature.signature());
        for (LicenseViolationInfo.LicenseFieldViolationInfo info : violationInfo.getViolations()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), info.errorMessage()));
        }
    }
}

