/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.ClusterStopper;
import org.apache.ignite.internal.cluster.management.events.BeforeStartRaftGroupEventParameters;
import org.apache.ignite.internal.cluster.management.events.ClusterManagerGroupEvent;
import org.apache.ignite.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.internal.eventlog.event.EventUser;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.gridgain.internal.eventlog.api.GridGainEventType;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.License;
import org.gridgain.internal.license.LicenseField;
import org.gridgain.internal.license.LicenseLimitChecker;
import org.gridgain.internal.license.LicenseMetricSource;
import org.gridgain.internal.license.LicenseSystemViews;
import org.gridgain.internal.license.LicenseValidator;
import org.gridgain.internal.license.LicenseViolationException;
import org.gridgain.internal.license.LicenseViolationInfo;
import org.gridgain.internal.license.LicenseWithSignature;
import org.gridgain.internal.license.configuration.LicenseConfiguration;
import org.gridgain.internal.license.configuration.LicenseView;
import org.gridgain.internal.license.event.LicenseEvent;
import org.gridgain.internal.license.event.LicenseEventParameters;
import org.gridgain.internal.license.event.LicenseUpdateEventParameters;
import org.gridgain.internal.license.provider.LicenseProvider;
import org.gridgain.internal.license.provider.LicenseProviderFactory;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GridLicenseManager
extends AbstractEventProducer<LicenseEvent, LicenseEventParameters>
implements IgniteComponent,
SystemViewProvider {
    private static final IgniteLogger LOG = Loggers.forClass(GridLicenseManager.class);
    private volatile License currentLicense = null;
    private final LicenseConfiguration licenseConfiguration;
    private final ConfigurationListener<LicenseView> licenseConfigurationListener;
    private final ClusterStopper clusterStopper;
    private final LogicalTopology logicalTopology;
    private final ScheduledExecutorService scheduledExecutor;
    private final Consumer<org.apache.ignite.internal.eventlog.api.Event> notifier;
    @Nullable
    private volatile ScheduledFuture<?> checkLicenseExpirationTaskFuture;
    private final MetricManager metricManager;
    private final LicenseProviderFactory licenseProviderFactory;

    public GridLicenseManager(LicenseConfiguration licenseConfiguration, ClusterManagementGroupManager cmgManager, LogicalTopology logicalTopology, ClusterStopper clusterStopper, ScheduledExecutorService scheduledExecutor, MetricManager metricManager, Consumer<org.apache.ignite.internal.eventlog.api.Event> notifier, LicenseProviderFactory licenseProviderFactory) {
        this.licenseConfiguration = licenseConfiguration;
        this.clusterStopper = clusterStopper;
        this.logicalTopology = logicalTopology;
        this.scheduledExecutor = scheduledExecutor;
        this.metricManager = metricManager;
        this.notifier = notifier;
        this.licenseProviderFactory = licenseProviderFactory;
        cmgManager.listen((Event)ClusterManagerGroupEvent.BEFORE_START_RAFT_GROUP, evt -> {
            BeforeStartRaftGroupEventParameters params = (BeforeStartRaftGroupEventParameters)evt;
            String clusterConfig = params.initialClusterConfig();
            if (clusterConfig == null) {
                return CompletableFutures.falseCompletedFuture();
            }
            Config config = ConfigFactory.parseString((String)clusterConfig);
            try {
                LicenseProvider licenseProvider = licenseProviderFactory.getAvailableLicenseProvider(config);
                return this.applyLicense(licenseProvider.getLicense()).thenApply(v -> false);
            }
            catch (Exception e) {
                this.logLicenseEvent(GridGainEventType.LICENSE_REJECTED, null);
                return CompletableFuture.failedFuture(e);
            }
        });
        this.licenseConfigurationListener = ctx -> {
            LicenseView view = (LicenseView)ctx.newValue();
            assert (view != null);
            if (licenseProviderFactory.isCloudLicenseAvailable() && view.content().isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            return this.applyLicense(LicenseWithSignature.parseLicense(view.content(), view.signature())).exceptionally(e -> {
                LOG.error("License rejected. Leaving the old license", e);
                return null;
            });
        };
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.licenseConfiguration.listen(this.licenseConfigurationListener);
        this.checkLicenseExpirationTaskFuture = this.scheduledExecutor.scheduleAtFixedRate(() -> {
            LicenseViolationInfo licenseViolationInfoHolder = this.verifyLicenseExpiration(LocalDate.now());
            if (licenseViolationInfoHolder.hasViolations()) {
                LOG.error(licenseViolationInfoHolder.formatViolationMessage(), new Object[0]);
                this.logLicenseViolation(this.currentLicense, licenseViolationInfoHolder.getViolations());
                this.clusterStopper.stopCluster("License is expired.");
            }
        }, GridLicenseManager.getDelayToNextDay(), TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS);
        this.registerMetricSource();
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.licenseConfiguration.stopListen(this.licenseConfigurationListener);
        ScheduledFuture<?> licenseExpirationTaskFuture = this.checkLicenseExpirationTaskFuture;
        if (licenseExpirationTaskFuture != null) {
            licenseExpirationTaskFuture.cancel(false);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> applyNewLicense(String license) {
        try {
            this.verifyLicense(LicenseWithSignature.parseLicense(license));
        }
        catch (LicenseViolationException e) {
            return CompletableFuture.failedFuture(e);
        }
        Config config = ConfigFactory.parseString((String)license);
        ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setJson(true);
        return this.licenseConfiguration.change(x -> x.changeContent(config.root().render(renderOptions)));
    }

    private void verifyLicense(LicenseWithSignature licenseWithSignature) {
        LicenseViolationInfo violationInfo;
        License localCurrentLicense;
        License newLicense = licenseWithSignature.license();
        if (newLicense.equals(localCurrentLicense = this.currentLicense)) {
            return;
        }
        if (localCurrentLicense == null) {
            violationInfo = LicenseValidator.verifyLicense(newLicense, licenseWithSignature.signature());
        } else {
            Set topologyNodes = this.logicalTopology.getLogicalTopology().nodes();
            violationInfo = LicenseValidator.verifyLicense(newLicense, licenseWithSignature.signature(), topologyNodes);
        }
        if (violationInfo.hasViolations()) {
            this.logLicenseEvent(GridGainEventType.LICENSE_REJECTED, newLicense);
            this.logLicenseViolation(newLicense, violationInfo.getViolations());
            throw new LicenseViolationException(violationInfo.formatViolationMessage());
        }
    }

    public String getCurrentLicense() {
        return this.currentLicense.config().root().render(ConfigRenderOptions.concise());
    }

    private CompletableFuture<Void> applyLicense(LicenseWithSignature newLicense) {
        this.verifyLicense(newLicense);
        this.currentLicense = newLicense.license();
        LOG.debug("License applied.", new Object[0]);
        this.logLicenseEvent(GridGainEventType.LICENSE_APPLIED, this.currentLicense);
        return this.fireEvent((Event)LicenseEvent.LICENSE_APPLIED, (EventParameters)LicenseUpdateEventParameters.applied((License)this.currentLicense));
    }

    @VisibleForTesting
    LicenseViolationInfo verifyLicenseExpiration(LocalDate currentDate) {
        LicenseViolationInfo licenseViolationInfoHolder = new LicenseViolationInfo();
        LocalDate expirationDate = (LocalDate)this.currentLicense.field((LicenseField)HoconLicenseField.EXPIRE_DATE);
        assert (expirationDate != null);
        if (currentDate.isAfter(expirationDate)) {
            licenseViolationInfoHolder.addViolation("expireDate", currentDate, expirationDate, String.format("License is expired. Expiration date: \"%s\"", expirationDate));
        } else {
            Duration tillExpiration = Duration.between(currentDate.atStartOfDay(), expirationDate.atStartOfDay());
            if (tillExpiration.compareTo(Duration.ofDays(90L)) <= 0) {
                LOG.warn("License is going to expire soon. Expiration date: \"{}\"", new Object[]{expirationDate});
            }
        }
        return licenseViolationInfoHolder;
    }

    License currentLicense() {
        return this.currentLicense;
    }

    private static long getDelayToNextDay() {
        LocalDate nextDay = LocalDate.now().plusDays(1L);
        Duration delay = Duration.between(LocalDateTime.now(), nextDay.atStartOfDay());
        return delay.toSeconds();
    }

    public List<SystemView<?>> systemViews() {
        return List.of(LicenseSystemViews.createLicenseSystemView(this));
    }

    private void registerMetricSource() {
        this.metricManager.registerSource((MetricSource)new LicenseMetricSource(this));
        this.metricManager.enable("license");
    }

    public CompletableFuture<Void> refreshLicense() {
        CompletableFuture<Void> applyLicenseFuture;
        LicenseView licenseView = (LicenseView)this.licenseConfiguration.value();
        if (this.licenseProviderFactory.isCloudLicenseAvailable() && licenseView.content().isEmpty()) {
            LicenseProvider licenseProvider = this.licenseProviderFactory.getAvailableLicenseProvider(null);
            applyLicenseFuture = this.applyLicense(licenseProvider.getLicense());
        } else {
            applyLicenseFuture = this.applyLicense(LicenseWithSignature.parseLicense(licenseView.content(), licenseView.signature()));
        }
        return ((CompletableFuture)applyLicenseFuture.handle(this::maybeOverrideLicense)).thenCompose(Function.identity());
    }

    private CompletableFuture<Void> maybeOverrideLicense(Void unused, Throwable throwable) {
        if (throwable != null) {
            String licenseOverridePath = IgniteSystemProperties.getString((String)"GG_LICENSE_OVERRIDE");
            if (licenseOverridePath != null) {
                try {
                    String license = Files.readString(Path.of(licenseOverridePath, new String[0]));
                    LOG.info("Overriding license from file \"{}\"", new Object[]{licenseOverridePath});
                    return this.applyLicense(LicenseWithSignature.parseLicense(license));
                }
                catch (IOException e) {
                    String message = IgniteStringFormatter.format((String)"Failed to read license override file \"{}\"", (Object[])new Object[]{licenseOverridePath});
                    LOG.error(message, (Throwable)e);
                    return CompletableFuture.failedFuture(new LicenseViolationException(message, (Throwable)e));
                }
            }
            if (throwable instanceof LicenseViolationException) {
                LOG.error("License violation detected. In order to restore cluster, set environment variable GG_LICENSE_OVERRIDE to the path of the valid license file on each node and start the nodes. Variable can be unset after successful start.", new Object[0]);
            }
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private void logLicenseEvent(GridGainEventType eventType, @Nullable License localLicense) {
        this.notifier.accept(eventType.builder().user(EventUser.system()).timestamp(System.currentTimeMillis()).fields(localLicense != null ? Map.of("licenseId", localLicense.field((LicenseField)HoconLicenseField.ID)) : null).build());
    }

    private void logLicenseViolation(License localLicense, Collection<LicenseViolationInfo.LicenseFieldViolationInfo> infos) {
        for (LicenseViolationInfo.LicenseFieldViolationInfo info : infos) {
            HashMap<String, String> fields = new HashMap<String, String>(Map.of("licenseId", (String)localLicense.field((LicenseField)HoconLicenseField.ID), "name", info.name(), "message", info.errorMessage()));
            if (info.value() != null) {
                fields.put("value", (String)info.value());
            }
            if (info.bound() != null) {
                fields.put("bound", (String)info.bound());
            }
            this.notifier.accept(GridGainEventType.LICENSE_VIOLATED.builder().user(EventUser.system()).timestamp(System.currentTimeMillis()).fields(fields).build());
        }
    }

    public void checkLimits() {
        Set topologyNodes = this.logicalTopology.getLogicalTopology().nodes();
        LicenseViolationInfo violationInfo = new LicenseViolationInfo();
        LicenseLimitChecker.checkAll(this.currentLicense, violationInfo, topologyNodes);
        if (violationInfo.hasViolations()) {
            this.logLicenseEvent(GridGainEventType.LICENSE_REJECTED, this.currentLicense);
            this.logLicenseViolation(this.currentLicense, violationInfo.getViolations());
            throw new LicenseViolationException(violationInfo.formatViolationMessage());
        }
    }
}

