/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.ldap;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.security.authentication.AuthenticationRequest;
import org.apache.ignite.internal.security.authentication.Authenticator;
import org.apache.ignite.internal.security.authentication.UserDetails;
import org.apache.ignite.internal.security.authentication.UsernamePasswordRequest;
import org.apache.ignite.security.exception.UnsupportedAuthenticationTypeException;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;
import org.gridgain.internal.security.ldap.LdapUserContext;
import org.gridgain.internal.security.ldap.client.LdapClient;
import org.gridgain.internal.security.ldap.configuration.LdapAuthenticationProviderView;
import org.gridgain.internal.security.ldap.configuration.LdapRoleMappingView;

public class LdapAuthenticator
implements Authenticator {
    private static final IgniteLogger LOG = Loggers.forClass(LdapAuthenticator.class);
    private static final Set<LicenseFeature> FEATURES = Set.of(LicenseFeature.LDAP, LicenseFeature.SECURITY);
    private final LdapClient client;
    private final LdapAuthenticationProviderView ldapAuthenticationProviderView;
    private final LicenseFeatureChecker licenseFeatureChecker;
    private final Executor authenticationExecutor;

    public LdapAuthenticator(LdapClient client, LdapAuthenticationProviderView ldapAuthenticationProviderView, LicenseFeatureChecker licenseFeatureChecker, Executor authenticationExecutor) {
        this.client = client;
        this.ldapAuthenticationProviderView = ldapAuthenticationProviderView;
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.authenticationExecutor = authenticationExecutor;
    }

    public CompletableFuture<UserDetails> authenticateAsync(AuthenticationRequest<?, ?> authenticationRequest) {
        try {
            this.licenseFeatureChecker.checkAnyFeature(FEATURES);
        }
        catch (MissingRequiredFeaturesException e) {
            LOG.info("LDAP license feature flag doesn't present.", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
        if (!(authenticationRequest instanceof UsernamePasswordRequest)) {
            throw new UnsupportedAuthenticationTypeException("Unsupported authentication type: " + authenticationRequest.getClass().getName());
        }
        return CompletableFuture.supplyAsync(() -> {
            LdapUserContext userContext = this.client.authenticate((String)authenticationRequest.getIdentity(), (String)authenticationRequest.getSecret());
            return this.mapUserContextToUserDetails(userContext);
        }, this.authenticationExecutor);
    }

    private UserDetails mapUserContextToUserDetails(LdapUserContext userContext) {
        Set roles = userContext.getGroups().stream().flatMap(group -> {
            LdapRoleMappingView view = (LdapRoleMappingView)this.ldapAuthenticationProviderView.roleMapping().get(group);
            if (view == null) {
                return Stream.of(group);
            }
            return Stream.of(view.roles());
        }).collect(Collectors.toSet());
        return new UserDetails(userContext.username(), this.ldapAuthenticationProviderView.name(), roles);
    }
}

