/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.ldap.client;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.ignite.internal.util.StringUtils;
import org.gridgain.internal.security.ldap.LdapCatalog;
import org.gridgain.internal.security.ldap.LdapSearchParams;
import org.gridgain.internal.security.ldap.exception.LdapAuthenticationException;
import org.gridgain.lang.GridgainErrorGroups;

public class LdapConnection
implements AutoCloseable {
    private final LdapSearchParams usersSearch;
    private final LdapSearchParams groupsSearch;
    private final LdapCatalog catalog;
    private final String user;

    public LdapConnection(String url, LdapSearchParams usersSearch, LdapSearchParams groupsSearch, String user, String password) throws NamingException {
        this.usersSearch = usersSearch;
        this.groupsSearch = groupsSearch;
        this.user = user;
        this.catalog = new LdapCatalog(url, this.defaultUserIdentifier(), password);
    }

    public Set<String> groups() throws LdapAuthenticationException {
        String userGroupAttr = this.usersSearch.attribute();
        if (!StringUtils.nullOrBlank((String)userGroupAttr)) {
            return this.resolveGroupsFromUserDn();
        }
        return this.resolveGroupsFromGroupDn();
    }

    private Set<String> resolveGroupsFromUserDn() throws LdapAuthenticationException {
        String userGroupAttr = this.usersSearch.attribute();
        List<String> list = this.extractUserAttribute(userGroupAttr);
        return new HashSet<String>(list);
    }

    private Set<String> resolveGroupsFromGroupDn() throws LdapAuthenticationException {
        String userIdentifier = this.extractUserIdentifier();
        try {
            List<Map<String, List<String>>> searchResult = this.catalog.search(this.groupsSearch.dn(), this.groupsSearch.filter().resolve(userIdentifier), this.groupsSearch.scope(), new String[0]);
            HashSet<String> result = new HashSet<String>();
            for (Map<String, List<String>> attrs : searchResult) {
                List<String> groupCn = attrs.get("cn");
                if (groupCn == null) continue;
                result.addAll(groupCn);
            }
            return result;
        }
        catch (NamingException e) {
            throw new LdapAuthenticationException(GridgainErrorGroups.Ldap.LDAP_SEARCH_REQUEST_ERR, "Ldap search request failed.", e);
        }
    }

    private String extractUserIdentifier() throws LdapAuthenticationException {
        String userAttr = this.groupsSearch.attribute();
        if (!StringUtils.nullOrBlank((String)userAttr)) {
            return this.extractUserAttribute(userAttr).get(0);
        }
        return this.defaultUserIdentifier();
    }

    private String defaultUserIdentifier() {
        return "cn=" + this.user + "," + this.usersSearch.dn();
    }

    private List<String> extractUserAttribute(String attribute) throws LdapAuthenticationException {
        try {
            List<Map<String, List<String>>> searchResult = this.catalog.search(this.usersSearch.dn(), this.usersSearch.filter().resolve(this.user), this.usersSearch.scope(), attribute);
            if (searchResult.isEmpty()) {
                throw new LdapAuthenticationException(GridgainErrorGroups.Ldap.LDAP_USER_NOT_FOUND_ERR, "User not found.");
            }
            if (searchResult.size() > 1) {
                throw new LdapAuthenticationException(GridgainErrorGroups.Ldap.LDAP_USER_NOT_FOUND_ERR, "Found more that one user with provided filter.");
            }
            return searchResult.get(0).get(attribute);
        }
        catch (NamingException e) {
            throw new LdapAuthenticationException(GridgainErrorGroups.Ldap.LDAP_SEARCH_REQUEST_ERR, "Ldap search request failed.", e);
        }
    }

    @Override
    public void close() throws NamingException {
        this.catalog.close();
    }
}

