/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ListValidator
implements ConfigDef.Validator,
ConfigDef.Recommender {
    private final List<String> validStrings;

    private ListValidator(List<String> validStrings) {
        this.validStrings = validStrings;
    }

    public static ListValidator ofEnum(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] enumVals = enumClass.getEnumConstants();
        ArrayList<String> res = new ArrayList<String>(enumVals.length);
        for (Enum<?> val : enumVals) {
            res.add(val.toString().toUpperCase());
        }
        return new ListValidator(res);
    }

    public List<Object> validValues(String s, Map<String, Object> map) {
        return this.validStrings;
    }

    public boolean visible(String s, Map<String, Object> map) {
        return true;
    }

    public void ensureValid(String name, Object o) {
        String s = ((String)o).toUpperCase();
        if (!this.validStrings.contains(s)) {
            throw new ConfigException(name, o, "String must be one of: " + String.join((CharSequence)", ", this.validStrings));
        }
    }
}

