/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.Map;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.AbstractGridGainConnectorConfig;
import org.gridgain.kafka.source.DateMode;
import org.gridgain.kafka.source.DateTimeMode;
import org.gridgain.kafka.source.SourceOffsetFailMode;
import org.gridgain.kafka.source.SourceOffsetMode;
import org.gridgain.kafka.source.TimeMode;
import org.gridgain.kafka.source.TimestampMode;
import org.gridgain.kafka.util.ListValidator;
import org.jetbrains.annotations.Nullable;

final class GridGainSourceConnectorConfig
extends AbstractGridGainConnectorConfig {
    private static final int MAX_TOPIC_PATTERNS = 3;
    private static final String TABLES_KEY = "ignite.tables";
    private static final String TABLES_DOC = "Comma-separated list of Ignite tables to source data from.";
    private static final String TABLE_TO_TOPIC_NAME_REGEX_KEY = "ignite.table.name.regex";
    private static final String TABLE_TO_TOPIC_NAME_REGEX_DOC = "Regex to convert Ignite table name to Kafka topic name. When null or empty, table name is used as topic name.";
    private static final String TABLE_TO_TOPIC_NAME_REGEX_REPLACEMENT_KEY = "ignite.table.name.regex.replacement";
    private static final String TABLE_TO_TOPIC_NAME_REGEX_REPLACEMENT_DOC = "Regex replacement to convert Ignite table name to Kafka topic name. When null or empty, table name is used as topic name.";
    private static final String IGNITE_QUERY_PAGE_SIZE = "ignite.query.page.size";
    private static final String IGNITE_QUERY_PAGE_SIZE_DOC = "Ignite query page size. The number of entries that will be fetched from the cluster in one network call.";
    private static final String IGNITE_QUERY_PREFETCH_PAGES = "ignite.query.prefetch.pages";
    private static final String IGNITE_QUERY_PREFETCH_PAGES_DOC = "Ignite query prefetch page count. The number of query pages that will be requested ahead of Kafka demand to reduce idling.";
    public static final String POLL_INTERVAL = "poll.interval";
    private static final String POLL_INTERVAL_DOC = "Frequency in ms to poll for new data.";
    public static final String SCHEMA_CACHE_MAX_SIZE = "schema.cache.max.size";
    private static final String SCHEMA_CACHE_MAX_SIZE_DOC = "Maximum number of Ignite-Kafka schema pairs to cache.";
    public static final String DATE_MODE = "date.mode";
    private static final String DATE_MODE_DOC = "Conversion mode for DATE columns. Allowed values are: INT32_ARRAY, STRING, KAFKA_DATE.";
    public static final String TIME_MODE = "time.mode";
    private static final String TIME_MODE_DOC = "Conversion mode for TIME columns. Allowed values are: INT32_ARRAY, STRING, KAFKA_TIME.";
    public static final String TIMESTAMP_MODE = "timestamp.mode";
    private static final String TIMESTAMP_MODE_DOC = "Conversion mode for TIMESTAMP columns. Allowed values are: FLOAT64, INT64, STRING, KAFKA_TIMESTAMP.";
    public static final String DATETIME_MODE = "datetime.mode";
    private static final String DATETIME_MODE_DOC = "Conversion mode for DATETIME columns. Allowed values are: INT32_ARRAY, STRING, KAFKA_TIMESTAMP.";
    public static final String SOURCE_OFFSET_MODE = "source.offset.mode";
    public static final String SOURCE_OFFSET_MODE_DOC = "Source offset store mode. Allowed values are: NONE, ALL. Default is ALL.ALL: guarantees at-least-once delivery of GridGain table updates even in case of Kafka connector restart by storing Ignite event id as part of Kafka SourceRecord. NONE: does not store Ignite event ids in Kafka and will skip the events that occur during connector restart; improves performance (stores less data in Kafka).";
    public static final String SOURCE_OFFSET_FAIL_MODE = "source.offset.fail.mode";
    public static final String SOURCE_OFFSET_FAIL_MODE_DOC = "Source offset fail mode. Allowed values are: FAIL, IGNORE. Default is FAIL.FAIL: fails the connector if the source offset (continuous query watermark) is too far back in the past (exceeds configured GridGain data availability time). IGNORE: ignores invalid offset error and starts capturing data events from the current point in time.";

    private GridGainSourceConnectorConfig(ConfigDef cfg, Map<String, String> props) {
        super(cfg, props);
    }

    GridGainSourceConnectorConfig(Map<String, String> props) {
        this(GridGainSourceConnectorConfig.conf(), props);
    }

    static ConfigDef conf() {
        ConfigDef def = GridGainSourceConnectorConfig.baseConf().define(TABLES_KEY, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, TABLES_DOC).define(TABLE_TO_TOPIC_NAME_REGEX_KEY, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TABLE_TO_TOPIC_NAME_REGEX_DOC).define(TABLE_TO_TOPIC_NAME_REGEX_REPLACEMENT_KEY, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TABLE_TO_TOPIC_NAME_REGEX_REPLACEMENT_DOC);
        for (int i = 1; i <= 3; ++i) {
            def.define("ignite.table.name.regex." + i, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TABLE_TO_TOPIC_NAME_REGEX_DOC);
            def.define("ignite.table.name.regex.replacement." + i, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TABLE_TO_TOPIC_NAME_REGEX_REPLACEMENT_DOC);
        }
        def.define(IGNITE_QUERY_PAGE_SIZE, ConfigDef.Type.INT, (Object)ContinuousQueryOptions.DEFAULT.pageSize(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, IGNITE_QUERY_PAGE_SIZE_DOC);
        def.define(POLL_INTERVAL, ConfigDef.Type.INT, (Object)ContinuousQueryOptions.DEFAULT.pollIntervalMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, POLL_INTERVAL_DOC);
        def.define(IGNITE_QUERY_PREFETCH_PAGES, ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, IGNITE_QUERY_PREFETCH_PAGES_DOC);
        def.define(SCHEMA_CACHE_MAX_SIZE, ConfigDef.Type.INT, (Object)1000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, SCHEMA_CACHE_MAX_SIZE_DOC);
        def.define(DATE_MODE, ConfigDef.Type.STRING, (Object)DateMode.INT32_ARRAY.name(), (ConfigDef.Validator)ListValidator.ofEnum(DateMode.class), ConfigDef.Importance.MEDIUM, DATE_MODE_DOC);
        def.define(TIME_MODE, ConfigDef.Type.STRING, (Object)TimeMode.INT32_ARRAY.name(), (ConfigDef.Validator)ListValidator.ofEnum(TimeMode.class), ConfigDef.Importance.MEDIUM, TIME_MODE_DOC);
        def.define(TIMESTAMP_MODE, ConfigDef.Type.STRING, (Object)TimestampMode.FLOAT64.name(), (ConfigDef.Validator)ListValidator.ofEnum(TimestampMode.class), ConfigDef.Importance.MEDIUM, TIMESTAMP_MODE_DOC);
        def.define(DATETIME_MODE, ConfigDef.Type.STRING, (Object)DateTimeMode.INT32_ARRAY.name(), (ConfigDef.Validator)ListValidator.ofEnum(DateTimeMode.class), ConfigDef.Importance.MEDIUM, DATETIME_MODE_DOC);
        def.define(SOURCE_OFFSET_MODE, ConfigDef.Type.STRING, (Object)SourceOffsetMode.ALL.name(), (ConfigDef.Validator)ListValidator.ofEnum(SourceOffsetMode.class), ConfigDef.Importance.MEDIUM, SOURCE_OFFSET_MODE_DOC);
        def.define(SOURCE_OFFSET_FAIL_MODE, ConfigDef.Type.STRING, (Object)SourceOffsetFailMode.FAIL.name(), (ConfigDef.Validator)ListValidator.ofEnum(SourceOffsetFailMode.class), ConfigDef.Importance.MEDIUM, SOURCE_OFFSET_FAIL_MODE_DOC);
        return def;
    }

    String[] tables() {
        String tablesCommaSeparated = (String)this.originals().get(TABLES_KEY);
        String[] tableNames = tablesCommaSeparated.split(",");
        for (int i = 0; i < tableNames.length; ++i) {
            tableNames[i] = tableNames[i].trim();
        }
        return tableNames;
    }

    String tableToTopicNameRegex(int index) {
        Object key = index == 0 ? TABLE_TO_TOPIC_NAME_REGEX_KEY : "ignite.table.name.regex." + index;
        return (String)this.originals().get(key);
    }

    String tableToTopicNameRegexReplacement(int index) {
        Object key = index == 0 ? TABLE_TO_TOPIC_NAME_REGEX_REPLACEMENT_KEY : "ignite.table.name.regex.replacement." + index;
        return (String)this.originals().get(key);
    }

    @Nullable
    Map.Entry<String, String> tableToTopicNameRegexPair(int index) {
        String regex = this.tableToTopicNameRegex(index);
        String replacement = this.tableToTopicNameRegexReplacement(index);
        if (regex == null || replacement == null) {
            return null;
        }
        return Map.entry(regex, replacement);
    }

    int pollInterval() {
        return this.getInt(POLL_INTERVAL);
    }

    int pageSize() {
        return this.getInt(IGNITE_QUERY_PAGE_SIZE);
    }

    int prefetchPages() {
        return this.getInt(IGNITE_QUERY_PREFETCH_PAGES);
    }

    int schemaCacheMaxSize() {
        return this.getInt(SCHEMA_CACHE_MAX_SIZE);
    }

    DateMode dateMode() {
        return DateMode.valueOf(this.getString(DATE_MODE));
    }

    TimeMode timeMode() {
        return TimeMode.valueOf(this.getString(TIME_MODE));
    }

    TimestampMode timestampMode() {
        return TimestampMode.valueOf(this.getString(TIMESTAMP_MODE));
    }

    DateTimeMode dateTimeMode() {
        return DateTimeMode.valueOf(this.getString(DATETIME_MODE));
    }

    SourceOffsetMode sourceOffsetMode() {
        return SourceOffsetMode.valueOf(this.getString(SOURCE_OFFSET_MODE));
    }

    SourceOffsetFailMode sourceOffsetFailMode() {
        return SourceOffsetFailMode.valueOf(this.getString(SOURCE_OFFSET_FAIL_MODE));
    }
}

