/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.AbstractGridGainConnectorConfig;
import org.gridgain.kafka.sink.DeploymentUnitsParser;
import org.gridgain.kafka.sink.ErrorHandlingPolicy;
import org.gridgain.kafka.sink.FlushMode;
import org.gridgain.kafka.sink.NestedStructMode;
import org.gridgain.kafka.sink.UnmappedFieldPolicy;
import org.gridgain.kafka.util.ListValidator;
import org.jetbrains.annotations.Nullable;

public final class GridGainSinkConnectorConfig
extends AbstractGridGainConnectorConfig {
    private static final int MAX_TOPIC_PATTERNS = 3;
    private static final String RETRY_BACKOFF = "retry.backoff";
    private static final int RETRY_BACKOFF_DEFAULT = 3000;
    private static final String RETRY_BACKOFF_MS_DOC = "The time in milliseconds to wait before retrying .";
    private static final String IGNITE_STREAMER_PAGE_SIZE = "ignite.streamer.page.size";
    private static final String IGNITE_STREAMER_PAGE_SIZE_DOC = "Ignite data streamer page size. The number of entries that will be sent to the cluster in one network call.";
    private static final String IGNITE_STREAMER_PARALLEL_OPS = "ignite.streamer.parallel.ops";
    private static final String IGNITE_STREAMER_PARALLEL_OPS_DOC = "Ignite data streamer parallel operations. The number of parallel operations per partition (how many in-flight requests can be active for a given partition).";
    private static final String IGNITE_STREAMER_AUTO_FLUSH_INTERVAL = "ignite.streamer.auto.flush.interval";
    private static final String IGNITE_STREAMER_AUTO_FLUSH_INTERVAL_DOC = "Ignite data streamer auto flush interval. The interval in milliseconds at which the data streamer will automatically flush the data to the cluster.";
    private static final String IGNITE_STREAMER_RETRY_LIMIT = "ignite.streamer.retry.limit";
    private static final String IGNITE_STREAMER_RETRY_LIMIT_DOC = "Ignite data streamer retry limit. The number of retries in case of a connection issue.";
    private static final String TOPIC_TO_TABLE_NAME_REGEX_KEY = "ignite.table.name.regex";
    private static final String TOPIC_NAME_TO_TABLE_NAME_REGEX_DOC = "Regex to convert Kafka topic name to Ignite table name. When null or empty, topic name is used as table name.";
    private static final String TOPIC_TO_TABLE_NAME_REGEX_REPLACEMENT_KEY = "ignite.table.name.regex.replacement";
    private static final String TOPIC_NAME_TO_TABLE_NAME_REGEX_REPLACEMENT_DOC = "Regex replacement to convert Kafka topic name to Ignite table name. When null or empty, topic name is used as table name.";
    private static final String NESTED_STRUCT_MODE = "nested.struct.mode";
    private static final String NESTED_STRUCT_MODE_DOC = "Mode to handle nested STRUCT fields. Possible values are: 'CONCAT', 'FLATTEN', 'IGNORE', 'DISALLOW'. Default is 'CONCAT', using separator defined in nested.struct.concat.separator.";
    private static final String NESTED_STRUCT_CONCAT_SEPARATOR = "nested.struct.concat.separator";
    private static final String NESTED_STRUCT_CONCAT_SEPARATOR_DOC = "Separator to concatenate nested field names into Ignite column name when nested.struct.mode=CONCAT. For example, if separator is '_', and nested field is 'address.street', then column name will be 'address_street'. Default is '_'.";
    private static final String FLUSH_MODE = "flush.mode";
    private static final String FLUSH_MODE_DOC = "Flush mode. Possible values are: 'KAFKA' (Kafka decides when to flush, based on offset.flush.interval.ms config), 'ON_PUT' (flush on every put - more frequent, might affect performance). Default is 'KAFKA'.";
    private static final String IGNITE_ERROR_HANDLING_POLICY = "ignite.error.handling.policy";
    private static final String IGNITE_ERROR_HANDLING_POLICY_DOC = "Error handling policy. Possible values are: 'LOG_ONLY' (log errors and continue processing), 'STOP_TASK' (stop the sink task on error), 'DEAD_LETTER_QUEUE' (redirect problematic records to the configured Dead Letter Queue topic and continue processing). Default is 'LOG_ONLY'.";
    private static final String IGNITE_STREAMER_RECEIVER_CLASS_NAME = "ignite.streamer.receiver.class.name";
    private static final String IGNITE_STREAMER_RECEIVER_CLASS_NAME_DOC = "Ignite data streamer receiver class name. The specified class must implement org.apache.ignite.table.DataStreamerReceiver<Tuple, Tuple, Void> interface. When not null, nested.struct.mode is only used for the key to determine the target node, and the receiver gets full Kafka records converted to Ignite Tuples with nesting. Streamer receiver arg is a Tuple with additional information: Kafka topic name and GridGain table name.";
    private static final String IGNITE_STREAMER_RECEIVER_DEPLOYMENT_UNITS = "ignite.streamer.receiver.deployment.units";
    private static final String IGNITE_STREAMER_RECEIVER_DEPLOYMENT_UNITS_DOC = "Ignite data streamer receiver deployment units. Comma-separated list of name:version pairs to look up the receiver class (ignite.streamer.receiver.class.name). Example: 'my-unit:1.1,my-unit:1.3'.";
    private static final String UNMAPPED_FIELD_POLICY = "unmapped.field.policy";
    private static final String UNMAPPED_FIELD_POLICY_DOC = "Unmapped field policy. Possible values are: 'FAIL', 'IGNORE'. Default is 'FAIL', which causes the conversion to fail if a column in Ignite table can't be found for a Kafka record field.When set to 'FAIL', the final result depends on the 'ignite.error.handling.policy' setting.";
    private static final String DROP_KEY_FIELDS = "drop.key.fields";
    private static final String DROP_KEY_FIELDS_DOC = "Comma-separated list of field names to drop from the Kafka key when converting the record to an Ignite row. '*' to drop the entire key. Nested fields can be specified using dot notation, e.g., 'address.street'.";
    private static final String DROP_VALUE_FIELDS = "drop.value.fields";
    private static final String DROP_VALUE_FIELDS_DOC = "Comma-separated list of field names to drop from the Kafka value when converting the record to an Ignite row. '*' to drop the entire value. Nested fields can be specified using dot notation, e.g., 'address.street'.";

    private GridGainSinkConnectorConfig(ConfigDef cfg, Map<String, String> props) {
        super(cfg, props);
    }

    GridGainSinkConnectorConfig(Map<String, String> props) {
        this(GridGainSinkConnectorConfig.conf(), props);
    }

    static ConfigDef conf() {
        ConfigDef def = GridGainSinkConnectorConfig.baseConf().define(RETRY_BACKOFF, ConfigDef.Type.INT, (Object)3000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, RETRY_BACKOFF_MS_DOC).define(IGNITE_STREAMER_PAGE_SIZE, ConfigDef.Type.INT, (Object)DataStreamerOptions.DEFAULT.pageSize(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, IGNITE_STREAMER_PAGE_SIZE_DOC).define(IGNITE_STREAMER_PARALLEL_OPS, ConfigDef.Type.INT, (Object)DataStreamerOptions.DEFAULT.perPartitionParallelOperations(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, IGNITE_STREAMER_PARALLEL_OPS_DOC).define(IGNITE_STREAMER_AUTO_FLUSH_INTERVAL, ConfigDef.Type.INT, (Object)DataStreamerOptions.DEFAULT.autoFlushInterval(), ConfigDef.Importance.MEDIUM, IGNITE_STREAMER_AUTO_FLUSH_INTERVAL_DOC).define(IGNITE_STREAMER_RETRY_LIMIT, ConfigDef.Type.INT, (Object)DataStreamerOptions.DEFAULT.retryLimit(), ConfigDef.Importance.MEDIUM, IGNITE_STREAMER_RETRY_LIMIT_DOC).define(TOPIC_TO_TABLE_NAME_REGEX_KEY, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TOPIC_NAME_TO_TABLE_NAME_REGEX_DOC).define(TOPIC_TO_TABLE_NAME_REGEX_REPLACEMENT_KEY, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TOPIC_NAME_TO_TABLE_NAME_REGEX_REPLACEMENT_DOC);
        for (int i = 1; i <= 3; ++i) {
            def.define("ignite.table.name.regex." + i, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TOPIC_NAME_TO_TABLE_NAME_REGEX_DOC);
            def.define("ignite.table.name.regex.replacement." + i, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, TOPIC_NAME_TO_TABLE_NAME_REGEX_REPLACEMENT_DOC);
        }
        def.define(NESTED_STRUCT_MODE, ConfigDef.Type.STRING, (Object)NestedStructMode.CONCAT.name(), (ConfigDef.Validator)ListValidator.ofEnum(NestedStructMode.class), ConfigDef.Importance.MEDIUM, NESTED_STRUCT_MODE_DOC);
        def.define(NESTED_STRUCT_CONCAT_SEPARATOR, ConfigDef.Type.STRING, (Object)"_", ConfigDef.Importance.MEDIUM, NESTED_STRUCT_CONCAT_SEPARATOR_DOC);
        def.define(FLUSH_MODE, ConfigDef.Type.STRING, (Object)FlushMode.KAFKA.name(), (ConfigDef.Validator)ListValidator.ofEnum(FlushMode.class), ConfigDef.Importance.MEDIUM, FLUSH_MODE_DOC);
        def.define(IGNITE_ERROR_HANDLING_POLICY, ConfigDef.Type.STRING, (Object)ErrorHandlingPolicy.LOG_ONLY.name(), (ConfigDef.Validator)ListValidator.ofEnum(ErrorHandlingPolicy.class), ConfigDef.Importance.MEDIUM, IGNITE_ERROR_HANDLING_POLICY_DOC);
        def.define(IGNITE_STREAMER_RECEIVER_CLASS_NAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, IGNITE_STREAMER_RECEIVER_CLASS_NAME_DOC);
        def.define(IGNITE_STREAMER_RECEIVER_DEPLOYMENT_UNITS, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, IGNITE_STREAMER_RECEIVER_DEPLOYMENT_UNITS_DOC);
        def.define(UNMAPPED_FIELD_POLICY, ConfigDef.Type.STRING, (Object)UnmappedFieldPolicy.FAIL.name(), (ConfigDef.Validator)ListValidator.ofEnum(UnmappedFieldPolicy.class), ConfigDef.Importance.MEDIUM, UNMAPPED_FIELD_POLICY_DOC);
        def.define(DROP_KEY_FIELDS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, DROP_KEY_FIELDS_DOC);
        def.define(DROP_VALUE_FIELDS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, DROP_VALUE_FIELDS_DOC);
        return def;
    }

    String topicToTableNameRegex(int index) {
        Object key = index == 0 ? TOPIC_TO_TABLE_NAME_REGEX_KEY : "ignite.table.name.regex." + index;
        return (String)this.originals().get(key);
    }

    private String topicToTableNameRegexReplacement(int index) {
        Object key = index == 0 ? TOPIC_TO_TABLE_NAME_REGEX_REPLACEMENT_KEY : "ignite.table.name.regex.replacement." + index;
        return (String)this.originals().get(key);
    }

    @Nullable
    Map.Entry<String, String> topicToTableNameRegexPair(int index) {
        String regex = this.topicToTableNameRegex(index);
        String replacement = this.topicToTableNameRegexReplacement(index);
        if (regex == null || replacement == null) {
            return null;
        }
        return Map.entry(regex, replacement);
    }

    int igniteStreamerPageSize() {
        return this.getInt(IGNITE_STREAMER_PAGE_SIZE);
    }

    int igniteStreamerParallelOps() {
        return this.getInt(IGNITE_STREAMER_PARALLEL_OPS);
    }

    int igniteStreamerAutoFlushInterval() {
        return this.getInt(IGNITE_STREAMER_AUTO_FLUSH_INTERVAL);
    }

    int igniteStreamerRetryLimit() {
        return this.getInt(IGNITE_STREAMER_RETRY_LIMIT);
    }

    int retryBackoff() {
        return this.getInt(RETRY_BACKOFF);
    }

    NestedStructMode nestedStructMode() {
        return NestedStructMode.valueOf(this.getString(NESTED_STRUCT_MODE).toUpperCase());
    }

    String nestedStructConcatSeparator() {
        return this.getString(NESTED_STRUCT_CONCAT_SEPARATOR);
    }

    FlushMode flushMode() {
        return FlushMode.valueOf(this.getString(FLUSH_MODE).toUpperCase());
    }

    ErrorHandlingPolicy errorHandlingPolicy() {
        return ErrorHandlingPolicy.valueOf(this.getString(IGNITE_ERROR_HANDLING_POLICY).toUpperCase());
    }

    @Nullable
    String igniteStreamerReceiverClassName() {
        return this.getString(IGNITE_STREAMER_RECEIVER_CLASS_NAME);
    }

    List<DeploymentUnit> igniteStreamerReceiverDeploymentUnits() {
        String unitsStr = this.getString(IGNITE_STREAMER_RECEIVER_DEPLOYMENT_UNITS);
        return DeploymentUnitsParser.parse(unitsStr);
    }

    UnmappedFieldPolicy unmappedFieldPolicy() {
        return UnmappedFieldPolicy.valueOf(this.getString(UNMAPPED_FIELD_POLICY).toUpperCase());
    }

    Set<String> dropKeyFields() {
        return GridGainSinkConnectorConfig.splitToSet(this.getString(DROP_KEY_FIELDS));
    }

    Set<String> dropValueFields() {
        return GridGainSinkConnectorConfig.splitToSet(this.getString(DROP_VALUE_FIELDS));
    }

    private static Set<String> splitToSet(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptySet();
        }
        String[] split = str.split(",");
        HashSet<String> result = new HashSet<String>(split.length);
        for (String s : split) {
            result.add(s.trim());
        }
        return result;
    }
}

