/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ignite.client.BasicAuthenticator;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.IgniteClientAuthenticator;
import org.apache.ignite.client.SslConfiguration;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGridGainConnectorConfig
extends AbstractConfig {
    private static final String IGNITE_ADDRESSES = "ignite.addresses";
    private static final String IGNITE_ADDRESSES_DOC = "Comma-separated list of Ignite server addresses (client endpoints).";
    private static final String IGNITE_CONNECT_TIMEOUT = "ignite.connect.timeout";
    private static final String IGNITE_CONNECT_TIMEOUT_DOC = "Sets the addresses of Ignite server nodes within a cluster. An address can be an IP address or a hostname, with or without port.";
    private static final String IGNITE_BACKGROUND_RECONNECT_INTERVAL = "ignite.background.reconnect.interval";
    private static final String IGNITE_BACKGROUND_RECONNECT_INTERVAL_DOC = "Background reconnect interval, in milliseconds. Set to 0 to disable background reconnect.";
    private static final String IGNITE_HEARTBEAT_INTERVAL = "ignite.heartbeat.interval";
    private static final String IGNITE_HEARTBEAT_INTERVAL_DOC = "An interval in milliseconds at which the client sends heartbeat messages to the cluster. Set to 0 to disable heartbeats.";
    private static final String IGNITE_HEARTBEAT_TIMEOUT = "ignite.heartbeat.timeout";
    private static final String IGNITE_HEARTBEAT_TIMEOUT_DOC = "Heartbeat response timeout, in milliseconds. The connection is closed if the response is not received within this timeout.";
    private static final String IGNITE_SSL_ENABLED = "ignite.ssl.enabled";
    private static final String IGNITE_SSL_ENABLED_DOC = "When true, an SSL/TLS connection will be established.";
    private static final String IGNITE_SSL_CIPHERS = "ignite.ssl.ciphers";
    private static final String IGNITE_SSL_CIPHERS_DOC = "Comma-separated list of ciphers that will be used to setup the SSL connection.";
    private static final String IGNITE_SSL_KEY_STORE_PATH = "ignite.ssl.key.store.path";
    private static final String IGNITE_SSL_KEY_STORE_PATH_DOC = "Keystore path that will be used to setup the SSL connection.";
    private static final String IGNITE_SSL_KEY_STORE_PASSWORD = "ignite.ssl.key.store.password";
    private static final String IGNITE_SSL_KEY_STORE_PASSWORD_DOC = "Keystore password that will be used to setup the SSL connection.";
    private static final String IGNITE_SSL_TRUST_STORE_PATH = "ignite.ssl.trust.store.path";
    private static final String IGNITE_SSL_TRUST_STORE_PATH_DOC = "Truststore path that will be used to setup the SSL connection.";
    private static final String IGNITE_SSL_TRUST_STORE_PASSWORD = "ignite.ssl.trust.store.password";
    private static final String IGNITE_SSL_TRUST_STORE_PASSWORD_DOC = "Truststore password that will be used to setup the SSL connection.";
    private static final String IGNITE_AUTHENTICATOR_BASIC_USERNAME = "ignite.authenticator.basic.username";
    private static final String IGNITE_AUTHENTICATOR_BASIC_USERNAME_DOC = "Username for basic authentication.";
    private static final String IGNITE_AUTHENTICATOR_BASIC_PASSWORD = "ignite.authenticator.basic.password";
    private static final String IGNITE_AUTHENTICATOR_BASIC_PASSWORD_DOC = "Password for basic authentication.";

    protected AbstractGridGainConnectorConfig(ConfigDef cfg, Map<String, String> props) {
        super(cfg, props);
    }

    protected static ConfigDef baseConf() {
        ConfigDef def = new ConfigDef().define(IGNITE_ADDRESSES, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, IGNITE_ADDRESSES_DOC).define(IGNITE_CONNECT_TIMEOUT, ConfigDef.Type.LONG, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, IGNITE_CONNECT_TIMEOUT_DOC).define(IGNITE_BACKGROUND_RECONNECT_INTERVAL, ConfigDef.Type.LONG, (Object)30000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, IGNITE_BACKGROUND_RECONNECT_INTERVAL_DOC).define(IGNITE_HEARTBEAT_INTERVAL, ConfigDef.Type.LONG, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, IGNITE_HEARTBEAT_INTERVAL_DOC).define(IGNITE_HEARTBEAT_TIMEOUT, ConfigDef.Type.LONG, (Object)5000, ConfigDef.Importance.MEDIUM, IGNITE_HEARTBEAT_TIMEOUT_DOC);
        def.define(IGNITE_SSL_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, IGNITE_SSL_ENABLED_DOC);
        def.define(IGNITE_SSL_CIPHERS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, IGNITE_SSL_CIPHERS_DOC);
        def.define(IGNITE_SSL_KEY_STORE_PATH, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, IGNITE_SSL_KEY_STORE_PATH_DOC);
        def.define(IGNITE_SSL_KEY_STORE_PASSWORD, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, IGNITE_SSL_KEY_STORE_PASSWORD_DOC);
        def.define(IGNITE_SSL_TRUST_STORE_PATH, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, IGNITE_SSL_TRUST_STORE_PATH_DOC);
        def.define(IGNITE_SSL_TRUST_STORE_PASSWORD, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, IGNITE_SSL_TRUST_STORE_PASSWORD_DOC);
        def.define(IGNITE_AUTHENTICATOR_BASIC_USERNAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, IGNITE_AUTHENTICATOR_BASIC_USERNAME_DOC);
        def.define(IGNITE_AUTHENTICATOR_BASIC_PASSWORD, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, IGNITE_AUTHENTICATOR_BASIC_PASSWORD_DOC);
        return def;
    }

    public String igniteAddresses() {
        return this.getString(IGNITE_ADDRESSES);
    }

    public long igniteConnectTimeout() {
        return this.getLong(IGNITE_CONNECT_TIMEOUT);
    }

    public long igniteBackgroundReconnectInterval() {
        return this.getLong(IGNITE_BACKGROUND_RECONNECT_INTERVAL);
    }

    public long igniteHeartbeatInterval() {
        return this.getLong(IGNITE_HEARTBEAT_INTERVAL);
    }

    public long igniteHeartbeatTimeout() {
        return this.getLong(IGNITE_HEARTBEAT_TIMEOUT);
    }

    public boolean igniteSslEnabled() {
        return this.getBoolean(IGNITE_SSL_ENABLED);
    }

    @Nullable
    public List<String> igniteSslCiphers() {
        String ciphers = this.getString(IGNITE_SSL_CIPHERS);
        return ciphers.isBlank() ? null : Arrays.asList(ciphers.split(","));
    }

    public String igniteSslKeyStorePath() {
        return this.getString(IGNITE_SSL_KEY_STORE_PATH);
    }

    public String igniteSslKeyStorePassword() {
        return this.getString(IGNITE_SSL_KEY_STORE_PASSWORD);
    }

    public String igniteSslTrustStorePath() {
        return this.getString(IGNITE_SSL_TRUST_STORE_PATH);
    }

    public String igniteSslTrustStorePassword() {
        return this.getString(IGNITE_SSL_TRUST_STORE_PASSWORD);
    }

    public String igniteAuthenticatorBasicUsername() {
        return this.getString(IGNITE_AUTHENTICATOR_BASIC_USERNAME);
    }

    public String igniteAuthenticatorBasicPassword() {
        return this.getString(IGNITE_AUTHENTICATOR_BASIC_PASSWORD);
    }

    public IgniteClient.Builder clientBuilder() {
        SslConfiguration sslConfig = SslConfiguration.builder().enabled(this.igniteSslEnabled()).ciphers(this.igniteSslCiphers()).keyStorePath(this.igniteSslKeyStorePath()).keyStorePassword(this.igniteSslKeyStorePassword()).trustStorePath(this.igniteSslTrustStorePath()).trustStorePassword(this.igniteSslTrustStorePassword()).build();
        BasicAuthenticator authenticator = this.igniteAuthenticatorBasicUsername().isBlank() ? null : BasicAuthenticator.builder().username(this.igniteAuthenticatorBasicUsername()).password(this.igniteAuthenticatorBasicPassword()).build();
        String[] addresses = this.igniteAddresses().split(",");
        return IgniteClient.builder().addresses(addresses).connectTimeout(this.igniteConnectTimeout()).backgroundReconnectInterval(this.igniteBackgroundReconnectInterval()).heartbeatInterval(this.igniteHeartbeatInterval()).heartbeatTimeout(this.igniteHeartbeatTimeout()).ssl(sslConfig).authenticator((IgniteClientAuthenticator)authenticator);
    }
}

