/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;

class StreamerPublisher<T>
implements Flow.Publisher<T>,
Flow.Subscription {
    private final AtomicLong requested = new AtomicLong();
    private Flow.Subscriber<? super T> subscriber;

    StreamerPublisher() {
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        assert (this.subscriber == null) : "Only one subscriber is supported";
        this.subscriber = subscriber;
        subscriber.onSubscribe(this);
    }

    @Override
    public void request(long n) {
        assert (n > 0L) : "Requested count must be positive";
        this.requested.addAndGet(n);
    }

    @Override
    public void cancel() {
    }

    boolean submit(T item) {
        if (this.requested.get() <= 0L) {
            return false;
        }
        this.subscriber.onNext(item);
        this.requested.decrementAndGet();
        return true;
    }

    void close() {
        this.subscriber.onComplete();
    }
}

