/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.deployment.version.Version;

class DeploymentUnitsParser {
    private static final String VERSION_SEPARATOR = ":";
    private static final String UNIT_SEPARATOR = ",";

    DeploymentUnitsParser() {
    }

    static List<DeploymentUnit> parse(String deploymentUnits) {
        if (deploymentUnits == null || deploymentUnits.isEmpty()) {
            return List.of();
        }
        String[] units = deploymentUnits.split(UNIT_SEPARATOR);
        ArrayList<DeploymentUnit> res = new ArrayList<DeploymentUnit>(units.length);
        for (String unit : units) {
            String[] parts = unit.split(VERSION_SEPARATOR);
            if (parts.length == 1) {
                res.add(new DeploymentUnit(parts[0].trim(), Version.LATEST));
                continue;
            }
            if (parts.length == 2) {
                res.add(new DeploymentUnit(parts[0].trim(), parts[1].trim()));
                continue;
            }
            throw new IllegalArgumentException("Invalid deployment unit format: " + unit);
        }
        return res;
    }
}

