/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TopicTableNameConverter {
    private final List<Map.Entry<Pattern, String>> patterns = new ArrayList<Map.Entry<Pattern, String>>();
    private final Map<String, String> cache = new HashMap<String, String>();

    public TopicTableNameConverter(Function<Integer, Map.Entry<String, String>> pairSupplier) {
        Map.Entry<String, String> pair;
        for (int i = 0; i < Integer.MAX_VALUE && (pair = pairSupplier.apply(i)) != null; ++i) {
            String regex = pair.getKey();
            String replacement = pair.getValue();
            this.patterns.add(Map.entry(Pattern.compile(regex), replacement == null ? "" : replacement));
        }
    }

    public String convert(String source) {
        String result = this.cache.get(source);
        if (result != null) {
            return result;
        }
        result = this.convertInternal(source);
        this.cache.put(source, result);
        return result;
    }

    private String convertInternal(String source) {
        for (Map.Entry<Pattern, String> entry : this.patterns) {
            Matcher matcher = entry.getKey().matcher(source);
            if (!matcher.matches()) continue;
            return matcher.replaceAll(entry.getValue());
        }
        return source;
    }
}

