/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.Base64;
import java.util.Map;
import org.apache.ignite.internal.continuousquery.ContinuousQueryEventWatermark;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.jetbrains.annotations.Nullable;

class OffsetUtils {
    private static final String WATERMARK_BYTES = "watermark-bytes";

    OffsetUtils() {
    }

    static Map<String, Object> kafkaSourcePartition(String tableName) {
        return Map.of("ignite-table", tableName);
    }

    @Nullable
    static ContinuousQueryEventWatermark readWatermark(OffsetStorageReader reader, String tableName) {
        Map offset = reader.offset(OffsetUtils.kafkaSourcePartition(tableName));
        return offset == null ? null : OffsetUtils.offsetToWatermark(offset);
    }

    static Map<String, Object> watermarkToOffset(byte @Nullable [] watermark) {
        if (watermark == null) {
            return Map.of();
        }
        return Map.of(WATERMARK_BYTES, watermark);
    }

    @Nullable
    private static ContinuousQueryEventWatermark offsetToWatermark(Map<String, Object> offset) {
        Object watermarkBytes = offset.get(WATERMARK_BYTES);
        if (watermarkBytes == null) {
            return null;
        }
        if (watermarkBytes instanceof byte[]) {
            return ContinuousQueryEventWatermark.fromBytes((byte[])((byte[])watermarkBytes));
        }
        if (watermarkBytes instanceof String) {
            byte[] decoded = Base64.getDecoder().decode((String)watermarkBytes);
            return ContinuousQueryEventWatermark.fromBytes((byte[])decoded);
        }
        throw new IllegalArgumentException("Unsupported watermark format: " + String.valueOf(watermarkBytes.getClass()) + " = " + String.valueOf(watermarkBytes));
    }
}

