/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.gridgain.kafka.source.SourceValueConverter;

final class KafkaSchema {
    private final Schema keySchema;
    private final Schema valueSchema;
    private final List<SourceValueConverter> converters;

    KafkaSchema(Schema keySchema, Schema valueSchema, List<SourceValueConverter> converters) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.converters = converters;
    }

    Schema keySchema() {
        return this.keySchema;
    }

    Schema valueSchema() {
        return this.valueSchema;
    }

    Object convert(Object value, int schemaIndex) {
        SourceValueConverter conv = this.converters.get(schemaIndex);
        return conv == null ? value : conv.apply(value);
    }
}

