/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.gridgain.kafka.DataGrid;
import org.gridgain.kafka.sink.KeyPolicy;

final class SinkRecordParser {
    private static final String DFLT_KEY_TYPE_NAME = "KafkaKey";
    private static final String DFLT_VAL_TYPE_NAME = "KafkaValue";
    private final KeyPolicy keyPlc;
    private final List<String> keyFields;

    SinkRecordParser(KeyPolicy keyPlc, List<String> keyFields) {
        this.keyPlc = keyPlc;
        this.keyFields = new ArrayList<String>(keyFields);
    }

    Object parseKey(SinkRecord rec) {
        switch (this.keyPlc) {
            case KEY: {
                return this.parse(rec.key(), rec.keySchema(), DFLT_KEY_TYPE_NAME);
            }
            case VALUE: {
                return this.buildKafkaKey(rec.value(), rec.valueSchema(), this.keyFields);
            }
            case KAFKA: {
                return SinkRecordParser.buildKafkaKey(rec.topic(), rec.kafkaPartition(), rec.kafkaOffset());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported key policy '%s'", new Object[]{this.keyPlc}));
    }

    Object parseValue(SinkRecord rec, String dfltTypeName) {
        return this.parse(rec.value(), rec.valueSchema(), dfltTypeName);
    }

    Object parseValue(SinkRecord rec) {
        return this.parse(rec.value(), rec.valueSchema(), DFLT_VAL_TYPE_NAME);
    }

    private static BinaryObject buildKafkaKey(String topic, int part, long off) {
        return DataGrid.SINK.binary().builder(DFLT_KEY_TYPE_NAME).setField("topic", (Object)topic).setField("partition", (Object)part).setField("offset", (Object)off).build();
    }

    private Object buildKafkaKey(Object obj, Schema schema, List<String> fields) {
        Struct newVal;
        Schema s;
        Schema schema2 = s = schema == null && obj instanceof Struct ? ((Struct)obj).schema() : schema;
        if (s == null) {
            throw new RuntimeException("Failed to build Kafka key from value: the value's schema is missing.");
        }
        if (s.type().isPrimitive()) {
            return obj;
        }
        Struct struct = (Struct)obj;
        Function<String, RuntimeException> fieldNotFound = f -> new RuntimeException(String.format("Failed to build Kafka key from value: the value has no field '%s'", f));
        if (fields.size() == 1) {
            Field f2 = s.field(fields.get(0));
            if (f2 == null) {
                throw fieldNotFound.apply(fields.get(0));
            }
            Schema newSchema = f2.schema();
            Object newObj = struct.get(f2);
            if (newSchema.type().isPrimitive()) {
                return newObj;
            }
            newVal = (Struct)newObj;
        } else {
            SchemaBuilder schemaBuilder = SchemaBuilder.struct();
            schemaBuilder.name(s.name());
            fields.forEach(fieldName -> {
                Field f = s.field(fieldName);
                if (f == null) {
                    throw (RuntimeException)fieldNotFound.apply((String)fieldName);
                }
                schemaBuilder.field(fieldName, f.schema());
            });
            Schema newSchema = schemaBuilder.build();
            newVal = new Struct(newSchema);
            for (String fieldName2 : fields) {
                newVal.put(fieldName2, struct.get(fieldName2));
            }
        }
        return this.createIgniteBinaryObject(newVal, newVal.schema());
    }

    private Object parse(Object obj, Schema schema, String dfltTypeName) {
        Schema s;
        Schema schema2 = s = schema == null && obj instanceof Struct ? ((Struct)obj).schema() : schema;
        if (s != null) {
            if (!s.type().isPrimitive()) {
                if (s.type() == Schema.Type.ARRAY) {
                    if (!s.valueSchema().type().isPrimitive()) {
                        return this.parseArray((List)obj, s);
                    }
                } else if (s.type() == Schema.Type.MAP) {
                    if (!s.keySchema().type().isPrimitive() || !s.valueSchema().type().isPrimitive()) {
                        return ((Map)obj).entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Object, Object>(this.parse(e.getKey(), s.keySchema(), DFLT_KEY_TYPE_NAME), this.parse(e.getValue(), s.valueSchema(), DFLT_VAL_TYPE_NAME))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
                    }
                } else {
                    Struct struct = (Struct)obj;
                    Object binObj = this.createIgniteBinaryObject(struct, s);
                    if (binObj != null) {
                        return binObj;
                    }
                }
            }
        } else if (obj instanceof Map) {
            return SinkRecordParser.toIgniteBinary((Map)obj, dfltTypeName);
        }
        return obj;
    }

    private static Object toIgniteBinary(Object obj, String typeName) {
        if (obj == null || SinkRecordParser.hasNativeIgniteType(obj.getClass())) {
            return obj;
        }
        if (obj instanceof Map) {
            return SinkRecordParser.toIgniteBinary((Map)obj, typeName);
        }
        if (obj instanceof List) {
            return SinkRecordParser.toIgniteBinary((List)obj, typeName);
        }
        throw new DataException("Failed to convert [" + obj + "]. Unsupported data type: " + obj.getClass().getName());
    }

    private static BinaryObject toIgniteBinary(Map<?, ?> map, String typeName) {
        BinaryObjectBuilder res = DataGrid.SINK.binary().builder(typeName);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String name = entry.getKey().toString();
            res.setField(name, SinkRecordParser.toIgniteBinary(entry.getValue(), name));
        }
        return res.build();
    }

    private static List<?> toIgniteBinary(List<?> lst, String typeName) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object o : lst) {
            res.add(SinkRecordParser.toIgniteBinary(o, typeName));
        }
        return res;
    }

    private static boolean hasNativeIgniteType(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return cls.isPrimitive() || cls == String.class || Number.class.isAssignableFrom(cls) || cls == Boolean.class || cls == Character.class || cls == UUID.class || cls == byte[].class || Date.class.isAssignableFrom(cls) || IgniteBinary.class.isAssignableFrom(cls) || SinkRecordParser.hasNativeIgniteType(cls.getComponentType());
    }

    private Object createIgniteBinaryObject(Struct struct, Schema schema) {
        IgniteBinary binary = DataGrid.SINK.binary();
        BinaryObjectBuilder binObj = binary.builder(schema.name());
        schema.fields().forEach(f -> {
            Schema fieldSchema = f.schema();
            Object fieldVal = struct.get(f);
            if (fieldVal != null) {
                binObj.setField(f.name(), this.parse(fieldVal, fieldSchema, f.name()));
            } else if (!fieldSchema.isOptional()) {
                throw new DataException("Mandatory field <" + f.name() + "> contains null");
            }
        });
        return binObj.build();
    }

    private Object parseArray(List<?> objs, Schema schema) {
        Schema valSchema = schema.valueSchema();
        ArrayList<Object> col = new ArrayList<Object>(objs.size());
        for (Object o : objs) {
            col.add(this.parse(o, valSchema, DFLT_VAL_TYPE_NAME));
        }
        return col;
    }
}

