/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;
import org.gridgain.kafka.DataGrid;
import org.gridgain.kafka.Version;
import org.gridgain.kafka.sink.IgniteSinkConnectorConfig;
import org.gridgain.kafka.sink.IgniteSinkTask;
import org.gridgain.kafka.sink.KeyPolicy;

public final class IgniteSinkConnector
extends SinkConnector {
    private IgniteSinkConnectorConfig cfg;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> map) {
        this.cfg = new IgniteSinkConnectorConfig(map);
        DataGrid.SINK.init(this.cfg.igniteCfg());
    }

    public Class<? extends Task> taskClass() {
        return IgniteSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks <= 0) {
            throw new IllegalArgumentException("Number of tasks must be a positive number.");
        }
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>(maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.cfg.originalsStrings());
        }
        return configs;
    }

    public void stop() {
        DataGrid.SINK.close();
    }

    public ConfigDef config() {
        return IgniteSinkConnectorConfig.conf();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Config cfg = super.validate(connectorConfigs);
        for (ConfigValue v : cfg.configValues()) {
            if (!v.name().equals(IgniteSinkConnectorConfig.KEY_POLICY.key()) || !KeyPolicy.VALUE.toString().equals(v.value()) || connectorConfigs.containsKey(IgniteSinkConnectorConfig.KEY_FIELDS.key())) continue;
            v.addErrorMessage(String.format("'%s' must be specified when '%s' is set to '%s'.", new Object[]{IgniteSinkConnectorConfig.KEY_FIELDS.key(), IgniteSinkConnectorConfig.KEY_POLICY.key(), KeyPolicy.VALUE}));
        }
        return cfg;
    }
}

