/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.CacheEntry;
import org.gridgain.kafka.ConfigOption;
import org.gridgain.kafka.EnumOption;
import org.gridgain.kafka.source.CacheToTopicMapper;
import org.gridgain.kafka.source.FailoverPolicy;
import org.gridgain.kafka.source.IdentityCacheToTopicMapper;
import org.gridgain.kafka.source.SourceEnumPolicy;
import org.gridgain.kafka.source.SourceErrorHandlingPolicy;
import org.gridgain.kafka.source.SourceFieldNullabilityPolicy;

public class IgniteSourceConnectorConfig
extends AbstractConfig {
    public static final String IGNITE_CFG_KEY = "igniteCfg";
    public static final String BACKLOG_SERVICE_NAME_KEY = "backlogServiceName";
    public static final ConfigOption<String> IGNITE_CFG = ConfigOption.high("igniteCfg", ConfigDef.Type.STRING, "", "Path to the Ignite configuration file. ``$IGNITE_HOME/config/default-config.xml`` is used if no Ignite config is configured");
    public static final ConfigOption<Boolean> SHALL_LOAD_INITIAL_DATA = ConfigOption.high("shallLoadInitialData", ConfigDef.Type.BOOLEAN, true, "Whether to load data already existing in Ignite caches at the time the Connector starts.");
    public static final ConfigOption<Boolean> SHALL_PROCESS_REMOVALS = ConfigOption.medium("shallProcessRemovals", ConfigDef.Type.BOOLEAN, false, "Set this setting to ``true`` to make the Connector process removals. In this case the Connector injects a record with ``null`` value into Kafka to indicate that the key was removed");
    public static final ConfigOption<Boolean> SHALL_PROCESS_EXPIRED = ConfigOption.medium("shallProcessExpired", ConfigDef.Type.BOOLEAN, false, "Set this setting to ``true`` to make the Connector process entry expire events. In this case the Connector injects a record with ``null`` value into Kafka to indicate that the key was removed");
    public static final ConfigOption<Integer> BATCH_SIZE = ConfigOption.low("batchSize", ConfigDef.Type.INT, 10000, "Maximum number of entries to send to Kafka in single batch.");
    public static final ConfigOption<String> TOPIC_PREFIX = ConfigOption.medium("topicPrefix", ConfigDef.Type.STRING, "", "The connector pulls data from Ignite caches into Kafka topics named by prefixing the cache names with this prefix.");
    public static final ConfigOption<Class<? extends CacheToTopicMapper>> CACHE_TO_TOPIC_MAPPER = ConfigOption.low("cache.to.topic.mapper", ConfigDef.Type.CLASS, IdentityCacheToTopicMapper.class, "Allows to specify custom cache to topic mapper");
    public static final ConfigOption<Long> POLL_INTERVAL = ConfigOption.low("pollInterval", ConfigDef.Type.LONG, 2000L, "Frequency in milliseconds to poll for new data in each cache.");
    public static final ConfigOption<Long> CACHE_LIST_POLL_INTERVAL = ConfigOption.low("cacheListPollInterval", ConfigDef.Type.LONG, 5000L, "Frequency in milliseconds to poll for the latest list of caches existing in Ignite.");
    public static final ConfigOption<List<String>> CACHE_WHITELIST = ConfigOption.low("cacheWhitelist", ConfigDef.Type.LIST, Collections.emptyList(), "List of regular expressions to match against names of caches.");
    public static final ConfigOption<List<String>> CACHE_BLACKLIST = ConfigOption.low("cacheBlacklist", ConfigDef.Type.LIST, Collections.emptyList(), "List of regular expressions to match against names of caches to exclude from copying. If both " + CACHE_WHITELIST.rst() + " and " + "%key_name%" + " are specified, then " + CACHE_WHITELIST.rst() + " is analysed first.");
    public static final ConfigOption<Class<? extends Predicate<CacheEntry>>> CACHE_FILTER = ConfigOption.low("cacheFilter", ConfigDef.Type.CLASS, null, "Class name of a custom ``java.util.function.Predicate<org.gridgain.kafka.CacheEntry>`` implementation to filter data pulled from Ignite caches.");
    public static final EnumOption<FailoverPolicy> FAILOVER_POLICY = EnumOption.high("failoverPolicy", FailoverPolicy.NONE, "The mode of handling Kafka Connect Worker failover and rebalancing. The options are:\n**" + (Object)((Object)FailoverPolicy.NONE) + "**: the Ignite cache updates that happened during the Connector downtime due to failover or rebalancing are lost. This options provides maximum performance.\n**" + (Object)((Object)FailoverPolicy.FULL_SNAPSHOT) + "**: pull all data from the Ignite caches each time the Connector starts. This option prevents data loss but is feasible only for small caches.\n**" + (Object)((Object)FailoverPolicy.BACKLOG) + "**: resume from the last committed offset. The Connector creates a special Kafka Backlog cache in Ignite where data from all caches are replicated and assigned offsets. The data is pulled from the Kafka Backlog. This option prevents data loss but consumes additional Ignite resources to manage the Kafka backlog cache and is less efficient due to extra data marshalling.");
    public static final ConfigOption<String> BACKLOG_CACHE_NAME = ConfigOption.low("backlogCacheName", ConfigDef.Type.STRING, "kafka-connect-backlog", "Name of a backlog cache created in GridGain where data from all caches are replicated and assigned offsets. " + ConfigOption.validWhen(FAILOVER_POLICY, (Object)FailoverPolicy.BACKLOG));
    public static final ConfigOption<String> BACKLOG_SERVICE_NAME = ConfigOption.low("backlogServiceName", ConfigDef.Type.STRING, "kafka-connect-backlog-service", "Name of a backlog service that manages backlog cache in GridGain. " + ConfigOption.validWhen(FAILOVER_POLICY, (Object)FailoverPolicy.BACKLOG));
    public static final ConfigOption<String> BACKLOG_DATA_REGION_NAME = ConfigOption.low("backlogMemoryRegionName", ConfigDef.Type.STRING, "kafka-connect", "Name of a memory region used to store backlog cache in GridGain. " + ConfigOption.validWhen(FAILOVER_POLICY, (Object)FailoverPolicy.BACKLOG));
    public static final ConfigOption<Integer> BACKLOG_CACHE_BACKUPS = ConfigOption.low("backlogCacheBackups", ConfigDef.Type.INT, 1, "Number of backups to keep for backlog cache. " + ConfigOption.validWhen(FAILOVER_POLICY, (Object)FailoverPolicy.BACKLOG));
    public static final ConfigOption<Integer> BACKLOG_FLUSH_FREQ = ConfigOption.low("backlogFlushFreq", ConfigDef.Type.INT, 500, "Frequency in milliseconds that the Backlog service flushes data to the Backlog cache. 0 means the setting is disabled" + ConfigOption.validWhen(FAILOVER_POLICY, (Object)FailoverPolicy.BACKLOG));
    public static final ConfigOption<Boolean> IS_SCHEMALESS = ConfigOption.low("isSchemaless", ConfigDef.Type.BOOLEAN, false, "By default source connector generates cache key and value schemas. Set this property to ``false`` to disable schema generation, which improves performance but does not allow non-GridGain sink connectors to understand the data structure.");
    public static final ConfigOption<Boolean> IS_SCHEMA_DYNAMIC = ConfigOption.medium("isSchemaDynamic", ConfigDef.Type.BOOLEAN, false, "By default key and value schemas for each Ignite cache are created only once (during processing of the first entry). Set this property to ``true`` to detect schema changes.");
    public static final ConfigOption<Boolean> ENABLE_ENTRIES_VALIDATION = ConfigOption.low("enableEntriesValidation", ConfigDef.Type.BOOLEAN, false, "If ``true`` connector will run additional checks for compatibility between provided value and schema (matters when " + IS_SCHEMA_DYNAMIC.rst() + " is enabled)");
    public static final ConfigOption<Boolean> ENABLE_SCHEMA_CACHE = ConfigOption.medium("enableSchemaCache", ConfigDef.Type.BOOLEAN, false, "Set this property to ``true`` to allow caching resolved kafka schemas. This can be useful in case when same cache can have objects with different binary schemas, so schemas caching can help us to avoid performing resolution for every incoming object");
    public static final ConfigOption<Boolean> ENABLE_SCHEMA_CACHE_STATS = ConfigOption.low("enableSchemaCacheStats", ConfigDef.Type.BOOLEAN, false, "**For internal usage only!** Enables collecting caffeine cache statistics. " + ConfigOption.validWhen(ENABLE_SCHEMA_CACHE, true));
    public static final ConfigOption<Integer> SCHEMA_CACHE_MAX_SIZE = ConfigOption.low("schemaCacheMaxSize", ConfigDef.Type.INT, 256, "Maximum capacity of resolved schemas cache. " + ConfigOption.validWhen(ENABLE_SCHEMA_CACHE, true));
    public static final ConfigOption<Integer> SCHEMA_CACHE_TTL = ConfigOption.low("schemaCacheTtl", ConfigDef.Type.INT, -1, "Time in milliseconds, since last entry access, after which this entry will be evicted from cache. Negative value means that not TTL would be applied. " + ConfigOption.validWhen(ENABLE_SCHEMA_CACHE, true));
    public static final EnumOption<SourceFieldNullabilityPolicy> NULLABILITY_POLICY = EnumOption.low("fieldNullabilityPolicy", SourceFieldNullabilityPolicy.LAZY, "Specifies how null fields mapped to Kafka schema. The options are:\n**" + (Object)((Object)SourceFieldNullabilityPolicy.LAZY) + "**: Simply return ``null``.\n**" + (Object)((Object)SourceFieldNullabilityPolicy.EAGER) + "**: Try to resolve schema based on available metadata (binary type metadata or pojo field class).");
    public static final EnumOption<SourceEnumPolicy> ENUM_POLICY = EnumOption.low("enumPolicy", SourceEnumPolicy.SHORT_NAME, "Specifies how enums mapped to Kafka schema. The options are:\n**" + (Object)((Object)SourceEnumPolicy.ORDINAL) + "**: Use Enum's ordinal value.\n**" + (Object)((Object)SourceEnumPolicy.SHORT_NAME) + "**: Use only name of enum element like ``BAR``.\n**" + (Object)((Object)SourceEnumPolicy.LONG_NAME) + "**: Use class name of enum element name like ``Foo.BAR``.\n**" + (Object)((Object)SourceEnumPolicy.FULL_NAME) + "**: Use full name of enum element like ``org.acme.Foo.BAR``.");
    public static final EnumOption<SourceErrorHandlingPolicy> ERROR_HANDLING_POLICY = EnumOption.low("errorHandlingPolicy", SourceErrorHandlingPolicy.STOP_TASK, "Controls how connector should handle errors during cache entries processing (i.e. schema resolution, key/value transformations, etc...). The options are:\n**" + (Object)((Object)SourceErrorHandlingPolicy.LOG_ONLY) + "**: Log problematic entry and skip it.\n**" + (Object)((Object)SourceErrorHandlingPolicy.STOP_TASK) + "**: Log problematic entry and transfer control to Kafka Connect which effectively will stop source task");
    private static final ConfigDef cfgDef = ConfigOption.buildCfgWith(IGNITE_CFG, SHALL_LOAD_INITIAL_DATA, SHALL_PROCESS_REMOVALS, SHALL_PROCESS_EXPIRED, BATCH_SIZE, TOPIC_PREFIX, CACHE_TO_TOPIC_MAPPER, POLL_INTERVAL, CACHE_LIST_POLL_INTERVAL, CACHE_WHITELIST, CACHE_BLACKLIST, CACHE_FILTER, IS_SCHEMALESS, IS_SCHEMA_DYNAMIC, ENABLE_ENTRIES_VALIDATION, ENABLE_SCHEMA_CACHE, ENABLE_SCHEMA_CACHE_STATS, SCHEMA_CACHE_MAX_SIZE, SCHEMA_CACHE_TTL, NULLABILITY_POLICY, ENUM_POLICY, ERROR_HANDLING_POLICY, FAILOVER_POLICY, BACKLOG_CACHE_NAME, BACKLOG_DATA_REGION_NAME, BACKLOG_SERVICE_NAME, BACKLOG_CACHE_BACKUPS, BACKLOG_FLUSH_FREQ);

    IgniteSourceConnectorConfig(ConfigDef cfg, Map<?, ?> props) {
        super(cfg, props);
    }

    IgniteSourceConnectorConfig(Map<?, ?> props) {
        this(IgniteSourceConnectorConfig.configDef(), props);
    }

    static ConfigDef configDef() {
        return cfgDef;
    }

    String igniteCfg() {
        return this.getString(IGNITE_CFG.key());
    }

    int batchSize() {
        return this.getInt(BATCH_SIZE.key());
    }

    String topicPrefix() {
        return this.getString(TOPIC_PREFIX.key());
    }

    long pollInterval() {
        return this.getLong(POLL_INTERVAL.key());
    }

    long cacheListPollInterval() {
        return this.getLong(CACHE_LIST_POLL_INTERVAL.key());
    }

    Collection<String> cacheWhitelist() {
        return this.getList(CACHE_WHITELIST.key());
    }

    Collection<String> cacheBlacklist() {
        return this.getList(CACHE_BLACKLIST.key());
    }

    String backlogCacheName() {
        return this.getString(BACKLOG_CACHE_NAME.key());
    }

    int backlogCacheBackups() {
        return this.getInt(BACKLOG_CACHE_BACKUPS.key());
    }

    String backlogServiceName() {
        return this.getString(BACKLOG_SERVICE_NAME.key());
    }

    String backlogDataRegionName() {
        return this.getString(BACKLOG_DATA_REGION_NAME.key());
    }

    boolean isSchemaless() {
        return this.getBoolean(IS_SCHEMALESS.key());
    }

    boolean isSchemaDynamic() {
        return this.getBoolean(IS_SCHEMA_DYNAMIC.key());
    }

    boolean isEntriesValidationEnabled() {
        return this.getBoolean(ENABLE_ENTRIES_VALIDATION.key());
    }

    boolean isSchemaCacheEnabled() {
        return this.getBoolean(ENABLE_SCHEMA_CACHE.key());
    }

    int schemaCacheMaxSize() {
        return this.getInt(SCHEMA_CACHE_MAX_SIZE.key());
    }

    int schemaCacheTtl() {
        return this.getInt(SCHEMA_CACHE_TTL.key());
    }

    boolean isSchemaCacheStatsEnabled() {
        return this.getBoolean(ENABLE_SCHEMA_CACHE_STATS.key());
    }

    SourceFieldNullabilityPolicy nullabilityPolicy() {
        return NULLABILITY_POLICY.extractFrom(this);
    }

    SourceEnumPolicy enumPolicy() {
        return ENUM_POLICY.extractFrom(this);
    }

    boolean shallProcessRemovals() {
        return this.getBoolean(SHALL_PROCESS_REMOVALS.key());
    }

    public boolean shallProcessExpired() {
        return this.getBoolean(SHALL_PROCESS_EXPIRED.key());
    }

    boolean shallLoadInitialData() {
        return this.getBoolean(SHALL_LOAD_INITIAL_DATA.key());
    }

    FailoverPolicy failoverPolicy() {
        return FAILOVER_POLICY.extractFrom(this);
    }

    SourceErrorHandlingPolicy errorHandlingPolicy() {
        return ERROR_HANDLING_POLICY.extractFrom(this);
    }

    int backlogFlushFreq() {
        return this.getInt(BACKLOG_FLUSH_FREQ.key());
    }

    Class<?> cacheFilter() {
        return this.getClass(CACHE_FILTER.key());
    }

    <M extends CacheToTopicMapper> Class<M> cacheToTopicMapper() {
        return this.getClass(CACHE_TO_TOPIC_MAPPER.key());
    }
}

