/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.sink.IgniteSinkConnectorConfig;
import org.gridgain.kafka.sink.TopicToCacheMapper;
import org.jetbrains.annotations.NotNull;

public class PrefixTopicToCacheMapper
implements TopicToCacheMapper {
    private String topicPrefix;
    private String cachePrefix;

    @Override
    public void init(Map<String, String> cfgMap) {
        Config config = new Config(cfgMap);
        this.topicPrefix = config.getString(IgniteSinkConnectorConfig.TOPIC_PREFIX.key());
        this.cachePrefix = config.getString(IgniteSinkConnectorConfig.CACHE_PREFIX.key());
    }

    @Override
    public String map(@NotNull String kafkaTopic) {
        Objects.requireNonNull(kafkaTopic, "topicName must not be null.");
        String topicWithoutPrefix = kafkaTopic.startsWith(this.topicPrefix) ? kafkaTopic.substring(this.topicPrefix.length()) : kafkaTopic;
        return this.cachePrefix + topicWithoutPrefix;
    }

    private static class Config
    extends AbstractConfig {
        static final ConfigDef confDef = new ConfigDef().define(IgniteSinkConnectorConfig.TOPIC_PREFIX.key(), ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, IgniteSinkConnectorConfig.TOPIC_PREFIX.doc()).define(IgniteSinkConnectorConfig.CACHE_PREFIX.key(), ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, IgniteSinkConnectorConfig.CACHE_PREFIX.doc());

        public Config(Map<?, ?> originals) {
            super(confDef, originals);
        }
    }
}

