/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.sink;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.IgniteConnectUtils;
import org.gridgain.kafka.InvalidConfigurationException;
import org.gridgain.kafka.sink.TopicToCacheMapper;

public class EnumeratedListTopicToCacheMapper
implements TopicToCacheMapper {
    public static final String TOPIC_TO_CACHE_MAPPING_KEY = "topic.to.cache.mapping";
    private static final String TOPIC_TO_CACHE_MAPPING_DOC = "Text-based mapping between topic name and cache name";
    private Map<String, String> mapping;

    @Override
    public void init(Map<String, String> cfgMap) {
        Config cfg = new Config(cfgMap);
        List pairs = cfg.getList(TOPIC_TO_CACHE_MAPPING_KEY);
        this.mapping = IgniteConnectUtils.parseMapping(pairs);
        boolean hasTopicList = cfg.originals().containsKey("topics");
        boolean hasTopicRegex = cfg.originals().containsKey("topics.regex");
        assert (hasTopicList ^ hasTopicRegex);
        if (hasTopicList) {
            this.validateAgainstTopicList(cfg.getList("topics"));
        }
        if (hasTopicRegex) {
            this.validateAgainstTopicRegex(cfg.getString("topics.regex"));
        }
    }

    @Override
    public String map(String kafkaTopic) {
        String cacheName = this.mapping.get(kafkaTopic);
        if (cacheName == null) {
            throw new IllegalArgumentException("Topic with name " + kafkaTopic + " is not defined in mapper configuration: " + TOPIC_TO_CACHE_MAPPING_KEY);
        }
        return cacheName;
    }

    private void validateAgainstTopicList(List<String> topicList) {
        HashSet<String> topics = new HashSet<String>(topicList);
        if (topics.size() != this.mapping.size()) {
            throw new InvalidConfigurationException("Inconsistent values between topics and topic.to.cache.mapping: different number of unique entries");
        }
        for (String topic : topics) {
            if (this.mapping.containsKey(topic)) continue;
            throw new InvalidConfigurationException("Inconsistent values between topics and topic.to.cache.mapping. Unknown key: " + topic);
        }
    }

    private void validateAgainstTopicRegex(String topicRegex) {
        Pattern pattern = Pattern.compile(topicRegex);
        for (String topic : this.mapping.keySet()) {
            if (pattern.matcher(topic).matches()) continue;
            throw new InvalidConfigurationException("Inconsistent values between topics.regex and topic.to.cache.mapping topic='" + topic + "' doesn't matches regex = '" + topicRegex + "'.");
        }
    }

    public static class Config
    extends AbstractConfig {
        private static final ConfigDef configDef = new ConfigDef().define("topics", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Standard configuration.").define("topics.regex", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Standard configuration.").define("topic.to.cache.mapping", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "Text-based mapping between topic name and cache name");

        public Config(Map<?, ?> originals) {
            super(configDef, originals);
        }
    }
}

