/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.gridgain.kafka.CacheEntry;
import org.gridgain.kafka.source.CacheEntryOffset;
import org.gridgain.kafka.source.CacheEntryRetriever;
import org.gridgain.kafka.source.FailoverPolicy;
import org.gridgain.kafka.source.Offsets;
import org.gridgain.kafka.source.QueryRetriever;
import org.gridgain.kafka.source.QueueingCacheEntryRetriever;
import org.jetbrains.annotations.Nullable;

public class QueueingQueryRetriever
implements QueueingCacheEntryRetriever {
    private final CacheEntryRetriever retriever;
    private final BlockingQueue<CacheEntry> cacheEntries = new LinkedBlockingQueue<CacheEntry>();
    private final int batchSize;

    QueueingQueryRetriever(Collection<String> cacheNames, Function<String, IgniteCache<BinaryObject, BinaryObject>> cacheGetter, FailoverPolicy failoverPlc, boolean shallLoadInitData, boolean shallProcRemovals, boolean shallProcExpired, int batchSize, Offsets offsets, @Nullable Predicate<CacheEntry> filter) {
        this.batchSize = batchSize;
        this.retriever = new QueryRetriever(cacheNames, offsets, cacheGetter, failoverPlc, shallLoadInitData, shallProcRemovals, shallProcExpired, this.cacheEntries::offer, filter);
    }

    @Override
    public List<CacheEntryOffset> get() {
        ArrayList buf = new ArrayList(this.batchSize);
        this.cacheEntries.drainTo(buf, this.batchSize);
        return buf.stream().map(e -> new CacheEntryOffset((CacheEntry)e, Offsets.NULL)).collect(Collectors.toList());
    }

    @Override
    public void reconfigure(Collection<String> rmvCaches, Collection<String> addedCaches) {
        this.retriever.reconfigure(rmvCaches, addedCaches);
    }

    @Override
    public void close() throws Exception {
        this.retriever.close();
    }
}

