/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka;

import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;

public class ConfigOption<T> {
    public static final String KEY_NAME = "%key_name%";
    protected final String key;
    protected final ConfigDef.Type type;
    protected final ConfigDef.Importance importance;
    protected final T dflt;
    protected final String doc;

    protected ConfigOption(String key, ConfigDef.Type type, ConfigDef.Importance importance, T dflt, String doc) {
        this.key = key;
        this.type = type;
        this.importance = importance;
        this.dflt = dflt;
        this.doc = doc.replaceAll(KEY_NAME, key);
    }

    public static <T> ConfigOption<T> high(String key, ConfigDef.Type type, T dflt, String doc) {
        return new ConfigOption<T>(key, type, ConfigDef.Importance.HIGH, dflt, doc);
    }

    public static <T> ConfigOption<T> medium(String key, ConfigDef.Type type, T dflt, String doc) {
        return new ConfigOption<T>(key, type, ConfigDef.Importance.MEDIUM, dflt, doc);
    }

    public static <T> ConfigOption<T> low(String key, ConfigDef.Type type, T dflt, String doc) {
        return new ConfigOption<T>(key, type, ConfigDef.Importance.LOW, dflt, doc);
    }

    public String key() {
        return this.key;
    }

    public String doc() {
        return this.doc;
    }

    public String rst() {
        return "``" + this.key + "``";
    }

    public T dflt() {
        return this.dflt;
    }

    public String toString() {
        return this.key;
    }

    public void applyTo(ConfigDef cfgDef) {
        cfgDef.define(this.key, this.type, this.dflt, this.importance, this.doc);
    }

    public static ConfigDef buildCfgWith(ConfigOption<?> ... opts) {
        ConfigDef def = new ConfigDef();
        Stream.of(opts).forEach(opt -> opt.applyTo(def));
        return def;
    }

    public static String validWhen(ConfigOption<?> opt, Object value) {
        return "This setting is valid only when " + opt.rst() + " is set to ``" + value + "``.";
    }
}

