/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import org.locationtech.jts.algorithm.HCoordinate;
import org.locationtech.jts.algorithm.NotRepresentableException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.TrianglePredicate;

public class Vertex {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BEYOND = 2;
    public static final int BEHIND = 3;
    public static final int BETWEEN = 4;
    public static final int ORIGIN = 5;
    public static final int DESTINATION = 6;
    private Coordinate p;

    public Vertex(double _x, double _y) {
        this.p = new Coordinate(_x, _y);
    }

    public Vertex(double _x, double _y, double _z) {
        this.p = new Coordinate(_x, _y, _z);
    }

    public Vertex(Coordinate _p) {
        this.p = new Coordinate(_p);
    }

    public double getX() {
        return this.p.x;
    }

    public double getY() {
        return this.p.y;
    }

    public double getZ() {
        return this.p.z;
    }

    public void setZ(double _z) {
        this.p.z = _z;
    }

    public Coordinate getCoordinate() {
        return this.p;
    }

    public String toString() {
        return "POINT (" + this.p.x + " " + this.p.y + ")";
    }

    public boolean equals(Vertex _x) {
        return this.p.x == _x.getX() && this.p.y == _x.getY();
    }

    public boolean equals(Vertex _x, double tolerance) {
        return this.p.distance(_x.getCoordinate()) < tolerance;
    }

    public int classify(Vertex p0, Vertex p1) {
        Vertex b;
        Vertex p2 = this;
        Vertex a = p1.sub(p0);
        double sa = a.crossProduct(b = p2.sub(p0));
        if (sa > 0.0) {
            return 0;
        }
        if (sa < 0.0) {
            return 1;
        }
        if (a.getX() * b.getX() < 0.0 || a.getY() * b.getY() < 0.0) {
            return 3;
        }
        if (a.magn() < b.magn()) {
            return 2;
        }
        if (p0.equals(p2)) {
            return 5;
        }
        if (p1.equals(p2)) {
            return 6;
        }
        return 4;
    }

    double crossProduct(Vertex v) {
        return this.p.x * v.getY() - this.p.y * v.getX();
    }

    double dot(Vertex v) {
        return this.p.x * v.getX() + this.p.y * v.getY();
    }

    Vertex times(double c) {
        return new Vertex(c * this.p.x, c * this.p.y);
    }

    Vertex sum(Vertex v) {
        return new Vertex(this.p.x + v.getX(), this.p.y + v.getY());
    }

    Vertex sub(Vertex v) {
        return new Vertex(this.p.x - v.getX(), this.p.y - v.getY());
    }

    double magn() {
        return Math.sqrt(this.p.x * this.p.x + this.p.y * this.p.y);
    }

    Vertex cross() {
        return new Vertex(this.p.y, -this.p.x);
    }

    public boolean isInCircle(Vertex a, Vertex b, Vertex c) {
        return TrianglePredicate.isInCircleRobust(a.p, b.p, c.p, this.p);
    }

    public final boolean isCCW(Vertex b, Vertex c) {
        return (b.p.x - this.p.x) * (c.p.y - this.p.y) - (b.p.y - this.p.y) * (c.p.x - this.p.x) > 0.0;
    }

    public final boolean rightOf(QuadEdge e) {
        return this.isCCW(e.dest(), e.orig());
    }

    public final boolean leftOf(QuadEdge e) {
        return this.isCCW(e.orig(), e.dest());
    }

    private HCoordinate bisector(Vertex a, Vertex b) {
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        HCoordinate l1 = new HCoordinate(a.getX() + dx / 2.0, a.getY() + dy / 2.0, 1.0);
        HCoordinate l2 = new HCoordinate(a.getX() - dy + dx / 2.0, a.getY() + dx + dy / 2.0, 1.0);
        return new HCoordinate(l1, l2);
    }

    private double distance(Vertex v1, Vertex v2) {
        return Math.sqrt(Math.pow(v2.getX() - v1.getX(), 2.0) + Math.pow(v2.getY() - v1.getY(), 2.0));
    }

    public double circumRadiusRatio(Vertex b, Vertex c) {
        Vertex x = this.circleCenter(b, c);
        double radius = this.distance(x, b);
        double edgeLength = this.distance(this, b);
        double el = this.distance(b, c);
        if (el < edgeLength) {
            edgeLength = el;
        }
        if ((el = this.distance(c, this)) < edgeLength) {
            edgeLength = el;
        }
        return radius / edgeLength;
    }

    public Vertex midPoint(Vertex a) {
        double xm = (this.p.x + a.getX()) / 2.0;
        double ym = (this.p.y + a.getY()) / 2.0;
        double zm = (this.p.z + a.getZ()) / 2.0;
        return new Vertex(xm, ym, zm);
    }

    public Vertex circleCenter(Vertex b, Vertex c) {
        Vertex a = new Vertex(this.getX(), this.getY());
        HCoordinate cab = this.bisector(a, b);
        HCoordinate cbc = this.bisector(b, c);
        HCoordinate hcc = new HCoordinate(cab, cbc);
        Vertex cc = null;
        try {
            cc = new Vertex(hcc.getX(), hcc.getY());
        }
        catch (NotRepresentableException nre) {
            System.err.println("a: " + a + "  b: " + b + "  c: " + c);
            System.err.println(nre);
        }
        return cc;
    }

    public double interpolateZValue(Vertex v0, Vertex v1, Vertex v2) {
        double x0 = v0.getX();
        double y0 = v0.getY();
        double a = v1.getX() - x0;
        double b = v2.getX() - x0;
        double c = v1.getY() - y0;
        double d = v2.getY() - y0;
        double det = a * d - b * c;
        double dx = this.getX() - x0;
        double dy = this.getY() - y0;
        double t2 = (d * dx - b * dy) / det;
        double u = (-c * dx + a * dy) / det;
        double z = v0.getZ() + t2 * (v1.getZ() - v0.getZ()) + u * (v2.getZ() - v0.getZ());
        return z;
    }

    public static double interpolateZ(Coordinate p, Coordinate v0, Coordinate v1, Coordinate v2) {
        double x0 = v0.x;
        double y0 = v0.y;
        double a = v1.x - x0;
        double b = v2.x - x0;
        double c = v1.y - y0;
        double d = v2.y - y0;
        double det = a * d - b * c;
        double dx = p.x - x0;
        double dy = p.y - y0;
        double t2 = (d * dx - b * dy) / det;
        double u = (-c * dx + a * dy) / det;
        double z = v0.z + t2 * (v1.z - v0.z) + u * (v2.z - v0.z);
        return z;
    }

    public static double interpolateZ(Coordinate p, Coordinate p0, Coordinate p1) {
        double segLen = p0.distance(p1);
        double ptLen = p.distance(p0);
        double dz = p1.z - p0.z;
        double pz = p0.z + dz * (ptLen / segLen);
        return pz;
    }
}

