/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.distance.FacetSequence;

public class FacetSequenceTreeBuilder {
    private static final int FACET_SEQUENCE_SIZE = 6;
    private static final int STR_TREE_NODE_CAPACITY = 4;

    public static STRtree build(Geometry g2) {
        STRtree tree = new STRtree(4);
        List sections = FacetSequenceTreeBuilder.computeFacetSequences(g2);
        for (FacetSequence section : sections) {
            tree.insert(section.getEnvelope(), (Object)section);
        }
        tree.build();
        return tree;
    }

    private static List computeFacetSequences(Geometry g2) {
        final ArrayList sections = new ArrayList();
        g2.apply(new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                CoordinateSequence seq = null;
                if (geom instanceof LineString) {
                    seq = ((LineString)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.addFacetSequences(seq, sections);
                } else if (geom instanceof Point) {
                    seq = ((Point)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.addFacetSequences(seq, sections);
                }
            }
        });
        return sections;
    }

    private static void addFacetSequences(CoordinateSequence pts, List sections) {
        int size = pts.size();
        for (int i = 0; i <= size - 1; i += 6) {
            int end = i + 6 + 1;
            if (end >= size - 1) {
                end = size;
            }
            FacetSequence sect = new FacetSequence(pts, i, end);
            sections.add(sect);
        }
    }
}

