/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.HCoordinate;
import org.locationtech.jts.geom.Coordinate;

public class Triangle {
    public Coordinate p0;
    public Coordinate p1;
    public Coordinate p2;

    public static boolean isAcute(Coordinate a, Coordinate b, Coordinate c) {
        if (!Angle.isAcute(a, b, c)) {
            return false;
        }
        if (!Angle.isAcute(b, c, a)) {
            return false;
        }
        return Angle.isAcute(c, a, b);
    }

    public static HCoordinate perpendicularBisector(Coordinate a, Coordinate b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        HCoordinate l1 = new HCoordinate(a.x + dx / 2.0, a.y + dy / 2.0, 1.0);
        HCoordinate l2 = new HCoordinate(a.x - dy + dx / 2.0, a.y + dx + dy / 2.0, 1.0);
        return new HCoordinate(l1, l2);
    }

    public static Coordinate circumcentre(Coordinate a, Coordinate b, Coordinate c) {
        double cx = c.x;
        double cy = c.y;
        double ax = a.x - cx;
        double ay = a.y - cy;
        double bx = b.x - cx;
        double by = b.y - cy;
        double denom = 2.0 * Triangle.det(ax, ay, bx, by);
        double numx = Triangle.det(ay, ax * ax + ay * ay, by, bx * bx + by * by);
        double numy = Triangle.det(ax, ax * ax + ay * ay, bx, bx * bx + by * by);
        double ccx = cx - numx / denom;
        double ccy = cy + numy / denom;
        return new Coordinate(ccx, ccy);
    }

    private static double det(double m00, double m01, double m10, double m11) {
        return m00 * m11 - m01 * m10;
    }

    public static Coordinate inCentre(Coordinate a, Coordinate b, Coordinate c) {
        double len0 = b.distance(c);
        double len1 = a.distance(c);
        double len2 = a.distance(b);
        double circum = len0 + len1 + len2;
        double inCentreX = (len0 * a.x + len1 * b.x + len2 * c.x) / circum;
        double inCentreY = (len0 * a.y + len1 * b.y + len2 * c.y) / circum;
        return new Coordinate(inCentreX, inCentreY);
    }

    public static Coordinate centroid(Coordinate a, Coordinate b, Coordinate c) {
        double x = (a.x + b.x + c.x) / 3.0;
        double y = (a.y + b.y + c.y) / 3.0;
        return new Coordinate(x, y);
    }

    public static double longestSideLength(Coordinate a, Coordinate b, Coordinate c) {
        double lenAB = a.distance(b);
        double lenBC = b.distance(c);
        double lenCA = c.distance(a);
        double maxLen = lenAB;
        if (lenBC > maxLen) {
            maxLen = lenBC;
        }
        if (lenCA > maxLen) {
            maxLen = lenCA;
        }
        return maxLen;
    }

    public static Coordinate angleBisector(Coordinate a, Coordinate b, Coordinate c) {
        double len0 = b.distance(a);
        double len2 = b.distance(c);
        double frac = len0 / (len0 + len2);
        double dx = c.x - a.x;
        double dy = c.y - a.y;
        Coordinate splitPt = new Coordinate(a.x + frac * dx, a.y + frac * dy);
        return splitPt;
    }

    public static double area(Coordinate a, Coordinate b, Coordinate c) {
        return Math.abs(((c.x - a.x) * (b.y - a.y) - (b.x - a.x) * (c.y - a.y)) / 2.0);
    }

    public static double signedArea(Coordinate a, Coordinate b, Coordinate c) {
        return ((c.x - a.x) * (b.y - a.y) - (b.x - a.x) * (c.y - a.y)) / 2.0;
    }

    public static double area3D(Coordinate a, Coordinate b, Coordinate c) {
        double ux = b.x - a.x;
        double uy = b.y - a.y;
        double uz = b.z - a.z;
        double vx = c.x - a.x;
        double vy = c.y - a.y;
        double vz = c.z - a.z;
        double crossx = uy * vz - uz * vy;
        double crossy = uz * vx - ux * vz;
        double crossz = ux * vy - uy * vx;
        double absSq = crossx * crossx + crossy * crossy + crossz * crossz;
        double area3D = Math.sqrt(absSq) / 2.0;
        return area3D;
    }

    public static double interpolateZ(Coordinate p, Coordinate v0, Coordinate v1, Coordinate v2) {
        double x0 = v0.x;
        double y0 = v0.y;
        double a = v1.x - x0;
        double b = v2.x - x0;
        double c = v1.y - y0;
        double d = v2.y - y0;
        double det = a * d - b * c;
        double dx = p.x - x0;
        double dy = p.y - y0;
        double t2 = (d * dx - b * dy) / det;
        double u = (-c * dx + a * dy) / det;
        double z = v0.z + t2 * (v1.z - v0.z) + u * (v2.z - v0.z);
        return z;
    }

    public Triangle(Coordinate p0, Coordinate p1, Coordinate p2) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    public Coordinate inCentre() {
        return Triangle.inCentre(this.p0, this.p1, this.p2);
    }

    public boolean isAcute() {
        return Triangle.isAcute(this.p0, this.p1, this.p2);
    }

    public Coordinate circumcentre() {
        return Triangle.circumcentre(this.p0, this.p1, this.p2);
    }

    public Coordinate centroid() {
        return Triangle.centroid(this.p0, this.p1, this.p2);
    }

    public double longestSideLength() {
        return Triangle.longestSideLength(this.p0, this.p1, this.p2);
    }

    public double area() {
        return Triangle.area(this.p0, this.p1, this.p2);
    }

    public double signedArea() {
        return Triangle.signedArea(this.p0, this.p1, this.p2);
    }

    public double area3D() {
        return Triangle.area3D(this.p0, this.p1, this.p2);
    }

    public double interpolateZ(Coordinate p) {
        if (p == null) {
            throw new IllegalArgumentException("Supplied point is null.");
        }
        return Triangle.interpolateZ(p, this.p0, this.p1, this.p2);
    }
}

