/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;

public class CGAlgorithms3D {
    private CGAlgorithms3D() {
    }

    public static double distance(Coordinate p0, Coordinate p1) {
        if (Double.isNaN(p0.z) || Double.isNaN(p1.z)) {
            return p0.distance(p1);
        }
        double dx = p0.x - p1.x;
        double dy = p0.y - p1.y;
        double dz = p0.z - p1.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distancePointSegment(Coordinate p, Coordinate A2, Coordinate B) {
        if (A2.equals3D(B)) {
            return CGAlgorithms3D.distance(p, A2);
        }
        double len2 = (B.x - A2.x) * (B.x - A2.x) + (B.y - A2.y) * (B.y - A2.y) + (B.z - A2.z) * (B.z - A2.z);
        if (Double.isNaN(len2)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        double r = ((p.x - A2.x) * (B.x - A2.x) + (p.y - A2.y) * (B.y - A2.y) + (p.z - A2.z) * (B.z - A2.z)) / len2;
        if (r <= 0.0) {
            return CGAlgorithms3D.distance(p, A2);
        }
        if (r >= 1.0) {
            return CGAlgorithms3D.distance(p, B);
        }
        double qx = A2.x + r * (B.x - A2.x);
        double qy = A2.y + r * (B.y - A2.y);
        double qz = A2.z + r * (B.z - A2.z);
        double dx = p.x - qx;
        double dy = p.y - qy;
        double dz = p.z - qz;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceSegmentSegment(Coordinate A2, Coordinate B, Coordinate C5, Coordinate D2) {
        double t2;
        double s2;
        if (A2.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(A2, C5, D2);
        }
        if (C5.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(C5, A2, B);
        }
        double a = Vector3D.dot(A2, B, A2, B);
        double b = Vector3D.dot(A2, B, C5, D2);
        double c = Vector3D.dot(C5, D2, C5, D2);
        double d = Vector3D.dot(A2, B, C5, A2);
        double e = Vector3D.dot(C5, D2, C5, A2);
        double denom = a * c - b * b;
        if (Double.isNaN(denom)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        if (denom <= 0.0) {
            s2 = 0.0;
            t2 = b > c ? d / b : e / c;
        } else {
            s2 = (b * e - c * d) / denom;
            t2 = (a * e - b * d) / denom;
        }
        if (s2 < 0.0) {
            return CGAlgorithms3D.distancePointSegment(A2, C5, D2);
        }
        if (s2 > 1.0) {
            return CGAlgorithms3D.distancePointSegment(B, C5, D2);
        }
        if (t2 < 0.0) {
            return CGAlgorithms3D.distancePointSegment(C5, A2, B);
        }
        if (t2 > 1.0) {
            return CGAlgorithms3D.distancePointSegment(D2, A2, B);
        }
        double x1 = A2.x + s2 * (B.x - A2.x);
        double y1 = A2.y + s2 * (B.y - A2.y);
        double z1 = A2.z + s2 * (B.z - A2.z);
        double x2 = C5.x + t2 * (D2.x - C5.x);
        double y2 = C5.y + t2 * (D2.y - C5.y);
        double z2 = C5.z + t2 * (D2.z - C5.z);
        return CGAlgorithms3D.distance(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }
}

