/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.function.Function;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.kafka.connect.data.Schema;
import org.gridgain.kafka.source.IgniteSourceConnectorConfig;
import org.gridgain.kafka.source.SourceEnumPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceEnumSchemaMapper {
    private static final SourceEnumSchemaMapper SHORT_NAME_MAPPER = new SourceEnumSchemaMapper(ec -> SourceEnumPolicy.SHORT_NAME.getSchema(), Enum::name, BinaryEnumObjectImpl::enumName);
    private static final SourceEnumSchemaMapper LONG_NAME_MAPPER = new SourceEnumSchemaMapper(ec -> SourceEnumPolicy.LONG_NAME.getSchema(), e -> e.getDeclaringClass().getSimpleName() + '.' + e.name(), be -> {
        String typeName = be.type().typeName();
        String shortTypeName = typeName.substring(typeName.lastIndexOf(".") + 1);
        return shortTypeName + '.' + be.enumName();
    });
    private static final SourceEnumSchemaMapper FULL_NAME_MAPPER = new SourceEnumSchemaMapper(ec -> SourceEnumPolicy.FULL_NAME.getSchema(), e -> e.getDeclaringClass().getName() + '.' + e.name(), be -> {
        String typeName = be.type().typeName();
        return typeName + '.' + be.enumName();
    });
    private static final SourceEnumSchemaMapper ORDINAL_MAPPER = new SourceEnumSchemaMapper(ec -> SourceEnumPolicy.ORDINAL.getSchema(), Enum::ordinal, BinaryEnumObjectImpl::enumOrdinal);
    private final Function<Class<?>, Schema> schemaMapper;
    private final Function<Enum<?>, Object> regularMapper;
    private final Function<BinaryEnumObjectImpl, Object> binaryMapper;

    private SourceEnumSchemaMapper(Function<Class<?>, Schema> schemaMapper, Function<Enum<?>, Object> regularMapper, Function<BinaryEnumObjectImpl, Object> binaryMapper) {
        this.schemaMapper = schemaMapper;
        this.regularMapper = regularMapper;
        this.binaryMapper = binaryMapper;
    }

    public static SourceEnumSchemaMapper from(IgniteSourceConnectorConfig cfg) {
        return SourceEnumSchemaMapper.of(cfg.enumPolicy());
    }

    public static SourceEnumSchemaMapper of(SourceEnumPolicy policy) {
        switch (policy) {
            case SHORT_NAME: {
                return SHORT_NAME_MAPPER;
            }
            case LONG_NAME: {
                return LONG_NAME_MAPPER;
            }
            case FULL_NAME: {
                return FULL_NAME_MAPPER;
            }
        }
        return ORDINAL_MAPPER;
    }

    @NotNull
    public Schema schemaFrom(@Nullable Class<?> ignored) {
        return this.schemaMapper.apply(ignored);
    }

    @NotNull
    public <T> T map(Enum<?> e) {
        return (T)this.regularMapper.apply(e);
    }

    @NotNull
    public <T> T mapBinary(BinaryEnumObjectImpl e) {
        return (T)this.binaryMapper.apply(e);
    }
}

