/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.stream.Collectors;

final class Offsets {
    private static final long NO_OFFSET = -1L;
    private final Map<Map<String, Object>, Map<String, Object>> kafkaOffsets;
    private long lastOff = -1L;
    static Map<String, Object> NULL = Offsets.kafkaOffset(-1L);

    Offsets() {
        this(null);
    }

    Offsets(Map<Map<String, Object>, Map<String, Object>> kafkaOffsets) {
        if (kafkaOffsets == null) {
            this.kafkaOffsets = new HashMap<Map<String, Object>, Map<String, Object>>();
        } else {
            this.kafkaOffsets = kafkaOffsets;
            OptionalLong max = kafkaOffsets.values().stream().filter(Objects::nonNull).flatMap(o -> o.entrySet().stream()).mapToLong(e -> (Long)e.getValue()).max();
            if (max.isPresent()) {
                this.lastOff = max.getAsLong();
            }
        }
    }

    static Collection<Map<String, Object>> kafkaPartitions(List<String> cacheNames) {
        return cacheNames.stream().map(Offsets::kafkaPartition).collect(Collectors.toList());
    }

    static Map<String, Object> kafkaPartition(String cacheName) {
        return Collections.singletonMap("cache", cacheName);
    }

    long last() {
        return this.lastOff;
    }

    Map<String, Object> set(String cache, long off) {
        Map<String, Object> res = Offsets.kafkaOffset(off);
        this.kafkaOffsets.put(Offsets.kafkaPartition(cache), res);
        this.lastOff = off;
        return res;
    }

    boolean isDefined(String cache) {
        Map<String, Object> kafkaOff = this.kafkaOffsets.get(Offsets.kafkaPartition(cache));
        return kafkaOff != null && kafkaOff.size() > 0 && kafkaOff.entrySet().iterator().next().getValue() != null;
    }

    public String toString() {
        Function<Map, String> partExtractor = m4 -> m4.entrySet().iterator().next().getValue().toString();
        Function<Map, String> offExtractor = m4 -> m4 == null ? null : m4.entrySet().iterator().next().getValue().toString();
        return this.kafkaOffsets.entrySet().stream().map(e -> String.format("%s@%s", offExtractor.apply((Map)e.getValue()), partExtractor.apply((Map)e.getKey()))).collect(Collectors.joining(" "));
    }

    private static Map<String, Object> kafkaOffset(long off) {
        return Collections.singletonMap("offset", off);
    }
}

