/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import org.gridgain.kafka.DataGrid;
import org.gridgain.kafka.source.IgniteSourceConnectorConfig;

public class IgniteSourceControl {
    public static void main(String[] args) {
        try {
            Configuration cfg = Configuration.parse(args);
            switch (cfg.command()) {
                case RMBACKLOG: {
                    IgniteSourceControl.removeBacklog(cfg);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private static void removeBacklog(Configuration cfg) {
        DataGrid.SOURCE.init(cfg.igniteCfg());
        DataGrid.SOURCE.removeService(cfg.backlogServiceName());
    }

    private static class Configuration {
        private Command cmd = Command.NONE;
        private String igniteCfg = null;
        private String backlogSrvcName = IgniteSourceConnectorConfig.BACKLOG_SERVICE_NAME.dflt();

        private Configuration() {
        }

        static Configuration parse(String[] args) throws Exception {
            Configuration cfg = new Configuration();
            if (args.length > 1) {
                try {
                    cfg.cmd = Enum.valueOf(Command.class, args[0].toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception(String.format("Unknown command %s\n\n%s\n", new Object[]{cfg.cmd, Configuration.usage()}), ex);
                }
                block10: for (int i = 1; i < args.length; ++i) {
                    switch (args[i]) {
                        case "--igniteCfg": {
                            if (++i == args.length) {
                                throw new Exception("igniteCfg value is missing");
                            }
                            cfg.igniteCfg = args[i];
                            continue block10;
                        }
                        case "--backlogServiceName": {
                            if (++i == args.length) {
                                throw new Exception("backlogServiceName value is missing");
                            }
                            cfg.backlogSrvcName = args[i];
                            continue block10;
                        }
                        default: {
                            throw new Exception(String.format("Unknown argument %s\n\n%s\n", args[i], Configuration.usage()));
                        }
                    }
                }
            } else {
                throw new Exception(Configuration.usage());
            }
            return cfg;
        }

        Command command() {
            return this.cmd;
        }

        String igniteCfg() {
            return this.igniteCfg;
        }

        String backlogServiceName() {
            return this.backlogSrvcName;
        }

        private static String usage() {
            return String.format("connect-ignite.sh CMD\n    [--%s: %s]\n    [--%s: %s]\n    CMD is one of:\n        %s: stop and remove Kafka Backlog infrastructure.", "igniteCfg", IgniteSourceConnectorConfig.IGNITE_CFG.doc(), "backlogServiceName", IgniteSourceConnectorConfig.BACKLOG_SERVICE_NAME.doc(), Command.RMBACKLOG.toString().toLowerCase());
        }
    }

    private static enum Command {
        NONE,
        RMBACKLOG;

    }
}

