/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.source;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.gridgain.kafka.source.CacheToTopicMapper;

public class IdentityCacheToTopicMapper
implements CacheToTopicMapper {
    public static final String TOPIC_PREFIX_KEY = "topicPrefix";
    private static final String TOPIC_PREFIX_DOC = "The connector pulls data from Ignite caches into Kafka topics named by prefixing the cache names with this prefix.";
    private String topicPrefix;

    @Override
    public void init(Map<String, String> cfgMap) {
        Config cfg = new Config(cfgMap);
        this.topicPrefix = cfg.getString(TOPIC_PREFIX_KEY);
    }

    @Override
    public String map(String cacheName) {
        if (cacheName == null) {
            throw new IllegalArgumentException("cacheName must not be null.");
        }
        return this.topicPrefix + cacheName;
    }

    private static class Config
    extends AbstractConfig {
        private static final ConfigDef confDef = new ConfigDef().define("topicPrefix", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "The connector pulls data from Ignite caches into Kafka topics named by prefixing the cache names with this prefix.");

        public Config(Map<?, ?> originals) {
            super(confDef, originals);
        }
    }
}

