/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryFieldMetadata;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.SchemaBuilderException;
import org.gridgain.kafka.LogFormat;
import org.gridgain.kafka.SystemEvent;
import org.gridgain.kafka.schema.ClassFieldsVisitor;
import org.gridgain.kafka.schema.ObjectFieldsVisitor;
import org.gridgain.kafka.schema.SchemaUtils;
import org.gridgain.kafka.schema.cache.ResolvedSchemasCache;
import org.gridgain.kafka.source.SourceFieldNullabilityPolicy;
import org.gridgain.kafka.source.SourceRecordBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaResolver {
    private static final Logger log = LoggerFactory.getLogger(SchemaResolver.class);
    private final SourceRecordBuilder.Context ctx;
    private final ParentTypes parentTypes = new ParentTypes();

    public SchemaResolver(@NotNull SourceRecordBuilder.Context cfg) {
        this.ctx = cfg;
    }

    @Nullable
    public Schema getSchema(@NotNull Object obj) throws SchemaBuilderException {
        return this.resolveSchema(obj);
    }

    @Nullable
    private Schema resolveSchema(@Nullable Object obj) throws SchemaBuilderException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BinaryObject) {
            return this.resolveBinarySchema((BinaryObject)obj);
        }
        Class<?> cls = obj.getClass();
        String typeName = cls.getName();
        if (obj instanceof Byte) {
            return Schema.OPTIONAL_INT8_SCHEMA;
        }
        if (obj instanceof Short) {
            return Schema.OPTIONAL_INT16_SCHEMA;
        }
        if (obj instanceof Integer || obj instanceof Character) {
            return Schema.OPTIONAL_INT32_SCHEMA;
        }
        if (obj instanceof Long) {
            return Schema.OPTIONAL_INT64_SCHEMA;
        }
        if (obj instanceof Float) {
            return Schema.OPTIONAL_FLOAT32_SCHEMA;
        }
        if (obj instanceof Double) {
            return Schema.OPTIONAL_FLOAT64_SCHEMA;
        }
        if (obj instanceof Boolean) {
            return Schema.OPTIONAL_BOOLEAN_SCHEMA;
        }
        if (obj instanceof byte[]) {
            return Schema.OPTIONAL_BYTES_SCHEMA;
        }
        if (obj instanceof String || obj instanceof UUID || obj instanceof Class) {
            return Schema.OPTIONAL_STRING_SCHEMA;
        }
        if (obj instanceof BigDecimal) {
            return Decimal.builder((int)((BigDecimal)obj).scale()).optional().build();
        }
        if (obj instanceof BigInteger) {
            return SchemaUtils.OPTIONAL_BIG_INT_SCHEMA;
        }
        if (obj instanceof java.util.Date) {
            if (obj instanceof Date) {
                return SchemaUtils.OPTIONAL_DATE_SCHEMA;
            }
            if (obj instanceof Time) {
                return SchemaUtils.OPTIONAL_TIME_SCHEMA;
            }
            return SchemaUtils.OPTIONAL_TIMESTAMP_SCHEMA;
        }
        if (obj instanceof Enum) {
            return this.fromEnum(obj);
        }
        if (cls.isArray()) {
            Class<?> elemType = cls.getComponentType();
            if (elemType.isPrimitive()) {
                return SchemaUtils.arraySchema(typeName, SchemaResolver.fromPrimitiveClass(elemType));
            }
            Schema elementSchemaCandidate = SchemaResolver.tryAsBoxedPrimitiveClass(elemType);
            if (elementSchemaCandidate != null) {
                return SchemaUtils.arraySchema(typeName, elementSchemaCandidate);
            }
            Object firstElement = SchemaResolver.extractArrayFirstElem((Object[])obj);
            return firstElement == null ? SchemaUtils.arraySchema(typeName, this.fromClass(elemType)) : this.resolveArraySchemaByElement(firstElement, typeName);
        }
        if (obj instanceof Collection) {
            return this.resolveArraySchema((Collection)obj, typeName);
        }
        if (obj instanceof Map) {
            return this.resolveMapSchema((Map)obj, typeName);
        }
        return this.resolve(typeName, () -> {
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().optional().name(typeName);
            ObjectFieldsVisitor.withClassFields(obj, (objField, instance) -> {
                Object fieldVal = objField.get(instance);
                Schema candidate = null;
                if (fieldVal == null) {
                    switch (this.ctx.getFieldNullabilityPolicy()) {
                        case EAGER: {
                            candidate = this.fromClass(objField.getType());
                            break;
                        }
                        case LAZY: {
                            candidate = this.fromPlainClasses(objField.getType());
                            break;
                        }
                    }
                } else {
                    Schema s2 = this.resolveSchema(fieldVal);
                    if (s2 == SchemaUtils.SKIP_SCHEMA) {
                        return;
                    }
                    candidate = SchemaResolver.orUndefined(s2);
                }
                if (SchemaUtils.isApplicable(candidate)) {
                    schemaBuilder.field(objField.getName(), candidate);
                }
            });
            return schemaBuilder.build();
        });
    }

    @Nullable
    private Schema resolveBinarySchema(BinaryObject binaryObject) {
        BinaryType binaryType = binaryObject.type();
        if (binaryType.isEnum()) {
            return this.fromEnum(binaryType);
        }
        BinaryObjectImpl binaryObjectImpl = (BinaryObjectImpl)binaryObject;
        BinaryContext binaryContext = binaryObjectImpl.context();
        BinaryMetadata binaryMetadata = binaryContext.metadata0(binaryType.typeId());
        if (binaryMetadata == null) {
            throw new ConnectException("Unable to find binary metadata, typeId=" + binaryType.typeId());
        }
        BinarySchema binarySchema = SchemaResolver.retrieveBinarySchema(binaryObjectImpl, binaryType, binaryContext);
        if (binarySchema == null) {
            throw new ConnectException("Unable to find appropriate binary schema, typeId=" + binaryType.typeId() + ", schemaId=" + binaryObjectImpl.schemaId());
        }
        return this.resolve(binaryType.typeName(), () -> this.resolveBinarySchema(binaryObjectImpl, binaryType, binarySchema, binaryMetadata));
    }

    private static BinarySchema retrieveBinarySchema(@NotNull BinaryObjectImpl binaryObject, @NotNull BinaryType binaryType, @NotNull BinaryContext binaryContext) {
        BinarySchema binarySchema = binaryContext.schemaRegistry(binaryType.typeId()).schema(binaryObject.schemaId());
        if (binarySchema == null) {
            return binaryObject.createSchema();
        }
        return binarySchema;
    }

    @NotNull
    private Schema resolveBinarySchema(@NotNull BinaryObjectImpl binaryObject, @NotNull BinaryType binaryType, @NotNull BinarySchema binarySchema, @NotNull BinaryMetadata binaryMetadata) {
        ResolvedSchemasCache schemasCache = this.ctx.getResolvedSchemasCache();
        if (schemasCache != null) {
            int schemaId;
            int typeId = binaryType.typeId();
            Schema result = schemasCache.get(typeId, schemaId = binarySchema.schemaId());
            if (result != null) {
                return result;
            }
            result = this.resolveBinarySchema0(binaryObject, binaryType, binarySchema, binaryMetadata);
            return schemasCache.put(typeId, schemaId, result);
        }
        return this.resolveBinarySchema0(binaryObject, binaryType, binarySchema, binaryMetadata);
    }

    @NotNull
    private Schema resolveBinarySchema0(@NotNull BinaryObjectImpl binaryObject, @NotNull BinaryType binaryType, @NotNull BinarySchema binarySchema, @NotNull BinaryMetadata binaryMetadata) {
        int[] fieldIds;
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().optional().name(binaryType.typeName());
        Map<Integer, T2<String, BinaryFieldMetadata>> fieldsMeta = SchemaResolver.collectFields(binaryMetadata);
        for (int fieldId : fieldIds = binarySchema.fieldIds()) {
            T2<String, BinaryFieldMetadata> fieldMeta = fieldsMeta.get(fieldId);
            String fieldName = (String)fieldMeta.get1();
            int fieldTypeId = ((BinaryFieldMetadata)fieldMeta.get2()).typeId();
            Schema fieldSchemaCandidate = SchemaResolver.fromPlainType(fieldTypeId);
            if (fieldSchemaCandidate != null) {
                schemaBuilder.field(fieldName, fieldSchemaCandidate);
                continue;
            }
            Object fieldValue = binaryObject.field(fieldId);
            fieldSchemaCandidate = this.tryAsLogicalType(fieldTypeId, fieldValue);
            if (fieldValue == null && this.ctx.getFieldNullabilityPolicy() == SourceFieldNullabilityPolicy.LAZY) {
                if (fieldSchemaCandidate == null) continue;
                schemaBuilder.field(fieldName, fieldSchemaCandidate);
                continue;
            }
            if (fieldSchemaCandidate == null) {
                fieldSchemaCandidate = this.tryAsCompositeType(fieldTypeId, fieldValue);
                if (fieldSchemaCandidate == SchemaUtils.SKIP_SCHEMA) continue;
                if (fieldSchemaCandidate == null) {
                    fieldSchemaCandidate = this.tryAsArrayType(fieldTypeId, fieldValue);
                }
            }
            schemaBuilder.field(fieldName, SchemaResolver.orUndefined(fieldSchemaCandidate));
        }
        return schemaBuilder.build();
    }

    @NotNull
    private static Map<Integer, T2<String, BinaryFieldMetadata>> collectFields(BinaryMetadata binaryMetadata) {
        return binaryMetadata.fieldsMap().entrySet().stream().collect(Collectors.toMap(e -> ((BinaryFieldMetadata)e.getValue()).fieldId(), e -> new T2(e.getKey(), e.getValue())));
    }

    @Nullable
    private static Schema fromPlainType(int typeId) {
        switch (typeId) {
            case 8: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case 1: {
                return Schema.OPTIONAL_INT8_SCHEMA;
            }
            case 2: {
                return Schema.OPTIONAL_INT16_SCHEMA;
            }
            case 3: 
            case 7: {
                return Schema.OPTIONAL_INT32_SCHEMA;
            }
            case 4: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case 5: {
                return Schema.OPTIONAL_FLOAT32_SCHEMA;
            }
            case 6: {
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case 9: 
            case 10: 
            case 32: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case 11: 
            case 33: {
                return SchemaUtils.OPTIONAL_TIMESTAMP_SCHEMA;
            }
            case 36: {
                return SchemaUtils.OPTIONAL_TIME_SCHEMA;
            }
        }
        return null;
    }

    @NotNull
    private Schema fromClass(@NotNull Class<?> cls) {
        Schema candidate = this.fromPlainClasses(cls);
        if (candidate != null) {
            return candidate;
        }
        if (Object.class.equals(cls)) {
            return SchemaUtils.UNDEFINED_SCHEMA;
        }
        if (cls.isArray()) {
            Class<?> elemType = cls.getComponentType();
            if (elemType.equals(Byte.TYPE)) {
                return Schema.OPTIONAL_BYTES_SCHEMA;
            }
            if (elemType.isPrimitive()) {
                return SchemaUtils.arraySchema(cls.getName(), SchemaResolver.fromPrimitiveClass(elemType));
            }
            Schema elementSchema = this.fromClass(elemType);
            return SchemaUtils.arraySchema(cls.getName(), elementSchema);
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return SchemaUtils.arraySchemaOfUndefined(cls.getName());
        }
        if (Map.class.isAssignableFrom(cls)) {
            return SchemaUtils.mapSchemaOfUndefined(cls.getName());
        }
        return SchemaResolver.orUndefined(this.resolvePojoSchema(cls));
    }

    @Nullable
    private Schema fromPlainClasses(@NotNull Class<?> cls) {
        if (cls.isPrimitive()) {
            return SchemaResolver.fromPrimitiveClass(cls);
        }
        Schema candidate = SchemaResolver.tryAsBoxedPrimitiveClass(cls);
        if (candidate != null) {
            return candidate;
        }
        if (String.class.equals(cls) || UUID.class.equals(cls) || Class.class.equals(cls)) {
            return Schema.OPTIONAL_STRING_SCHEMA;
        }
        if (BigDecimal.class.equals(cls)) {
            return Decimal.builder((int)0).optional().build();
        }
        if (BigInteger.class.equals(cls)) {
            return SchemaUtils.OPTIONAL_BIG_INT_SCHEMA;
        }
        if (Date.class.equals(cls)) {
            return SchemaUtils.OPTIONAL_DATE_SCHEMA;
        }
        if (Time.class.equals(cls)) {
            return SchemaUtils.OPTIONAL_TIME_SCHEMA;
        }
        if (java.util.Date.class.equals(cls)) {
            return SchemaUtils.OPTIONAL_TIMESTAMP_SCHEMA;
        }
        if (cls.isEnum()) {
            return this.fromEnum(cls);
        }
        return null;
    }

    @Nullable
    private Schema resolvePojoSchema(@NotNull Class<?> pojoCls) {
        String typeName = pojoCls.getName();
        return this.resolve(typeName, () -> {
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().optional().name(typeName);
            ClassFieldsVisitor.withClassFields(pojoCls, clsField -> {
                Schema clsFieldSchema = this.fromClass(clsField.getType());
                if (SchemaUtils.isApplicable(clsFieldSchema)) {
                    schemaBuilder.field(clsField.getName(), clsFieldSchema);
                }
            });
            return schemaBuilder.build();
        });
    }

    @NotNull
    private static Schema fromPrimitiveClass(@NotNull Class<?> cls) {
        if (cls.equals(Byte.TYPE)) {
            return Schema.INT8_SCHEMA;
        }
        if (cls.equals(Short.TYPE)) {
            return Schema.INT16_SCHEMA;
        }
        if (cls.equals(Integer.TYPE) || cls.equals(Character.TYPE)) {
            return Schema.INT32_SCHEMA;
        }
        if (cls.equals(Long.TYPE)) {
            return Schema.INT64_SCHEMA;
        }
        if (cls.equals(Float.TYPE)) {
            return Schema.FLOAT32_SCHEMA;
        }
        if (cls.equals(Double.TYPE)) {
            return Schema.FLOAT64_SCHEMA;
        }
        if (cls.equals(Boolean.TYPE)) {
            return Schema.BOOLEAN_SCHEMA;
        }
        throw new SchemaBuilderException("Unable to map " + cls.getName() + " to Kafka type");
    }

    @Nullable
    private static Schema tryAsBoxedPrimitiveClass(@NotNull Class<?> cls) {
        if (cls.equals(Byte.class)) {
            return Schema.OPTIONAL_INT8_SCHEMA;
        }
        if (cls.equals(Short.class)) {
            return Schema.OPTIONAL_INT16_SCHEMA;
        }
        if (cls.equals(Integer.class) || cls.equals(Character.class)) {
            return Schema.OPTIONAL_INT32_SCHEMA;
        }
        if (cls.equals(Long.class)) {
            return Schema.OPTIONAL_INT64_SCHEMA;
        }
        if (cls.equals(Float.class)) {
            return Schema.OPTIONAL_FLOAT32_SCHEMA;
        }
        if (cls.equals(Double.class)) {
            return Schema.OPTIONAL_FLOAT64_SCHEMA;
        }
        if (cls.equals(Boolean.class)) {
            return Schema.OPTIONAL_BOOLEAN_SCHEMA;
        }
        return null;
    }

    @NotNull
    private Schema fromEnum(@Nullable Object ignored) {
        return this.ctx.getEnumMapper().schemaFrom(null);
    }

    @Nullable
    private Schema tryAsLogicalType(int typeId, @Nullable Object value) {
        switch (typeId) {
            case 30: {
                return Decimal.builder((int)(value != null ? ((BigDecimal)value).scale() : 0)).optional().build();
            }
            case 28: {
                return this.fromEnum(value);
            }
        }
        return null;
    }

    @Nullable
    private Schema tryAsCompositeType(int typeId, @Nullable Object value) {
        switch (typeId) {
            case 103: {
                return this.resolveSchema(value);
            }
            case 25: {
                if (value == null) {
                    return SchemaUtils.mapSchemaOfUndefined(null);
                }
                if (value instanceof Map) {
                    return this.resolveMapSchema((Map)value);
                }
                throw new SchemaBuilderException("Can't process provided data as Map: " + value);
            }
            case 24: {
                if (value == null) {
                    return SchemaUtils.arraySchemaOfUndefined(null);
                }
                if (value instanceof Collection) {
                    return this.resolveArraySchema((Collection)value);
                }
                throw new SchemaBuilderException("Can't process provided data as Collection: " + value);
            }
        }
        return null;
    }

    @Nullable
    private Schema tryAsArrayType(int arrayTypeId, @Nullable Object arrayValue) {
        if (arrayTypeId == 12) {
            return Schema.OPTIONAL_BYTES_SCHEMA;
        }
        int elementType = SchemaResolver.arrayToElementType(arrayTypeId);
        if (elementType == 0) {
            return null;
        }
        Schema elementSchema = SchemaResolver.fromPlainType(elementType);
        if (elementSchema != null) {
            return SchemaUtils.arraySchema(BinaryUtils.fieldTypeName(arrayTypeId), elementSchema);
        }
        if (arrayValue == null) {
            return SchemaUtils.arraySchemaOfUndefined(null);
        }
        Object firstElem = SchemaResolver.extractArrayFirstElem((Object[])arrayValue);
        if (elementType == 103 && firstElem == null) {
            return SchemaUtils.arraySchemaOfUndefined(arrayValue.getClass().getName());
        }
        elementSchema = this.tryAsLogicalType(elementType, firstElem);
        if (elementSchema != null) {
            return SchemaUtils.arraySchema(arrayValue.getClass().getName(), elementSchema);
        }
        elementSchema = this.resolveSchema(firstElem);
        if (elementSchema == null) {
            throw new SchemaBuilderException("Unexpected null-schema for array element type: " + arrayTypeId);
        }
        return SchemaUtils.arraySchema(arrayValue.getClass().getName(), elementSchema);
    }

    private static int arrayToElementType(int arrayType) {
        switch (arrayType) {
            case 19: {
                return 8;
            }
            case 18: {
                return 7;
            }
            case 12: {
                return 1;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 3;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return 5;
            }
            case 17: {
                return 6;
            }
            case 20: {
                return 9;
            }
            case 21: {
                return 10;
            }
            case 22: {
                return 11;
            }
            case 37: {
                return 36;
            }
            case 34: {
                return 33;
            }
            case 23: {
                return 103;
            }
            case 31: {
                return 30;
            }
            case 29: {
                return 28;
            }
        }
        return 0;
    }

    @NotNull
    private Schema resolveMapSchemaByEntry(@Nullable Map.Entry<?, ?> firstEntry, @Nullable String typeName) {
        Schema keySchema = firstEntry != null ? this.resolveSchema(firstEntry.getKey()) : null;
        Schema valSchema = firstEntry != null ? this.resolveSchema(firstEntry.getValue()) : null;
        return SchemaUtils.mapSchema(SchemaResolver.orUndefined(keySchema), SchemaResolver.orUndefined(valSchema), typeName);
    }

    @NotNull
    private Schema resolveMapSchema(@NotNull Map<?, ?> mapValue, @NotNull String typeName) {
        return this.resolveMapSchemaByEntry(SchemaResolver.extractCollectionFirstElem(mapValue.entrySet()), typeName);
    }

    @NotNull
    private Schema resolveMapSchema(@NotNull Map<?, ?> mapValue) {
        return this.resolveMapSchema(mapValue, mapValue.getClass().getName());
    }

    @NotNull
    private Schema resolveArraySchemaByElement(@Nullable Object firstElem, @Nullable String name) {
        Schema s2 = this.resolveSchema(firstElem);
        return SchemaUtils.arraySchema(name, SchemaUtils.isApplicable(s2) ? s2 : SchemaUtils.UNDEFINED_SCHEMA);
    }

    @NotNull
    private Schema resolveArraySchema(@NotNull Collection<?> colValue, @NotNull String name) {
        return this.resolveArraySchemaByElement(SchemaResolver.extractCollectionFirstElem(colValue), name);
    }

    @NotNull
    private Schema resolveArraySchema(@NotNull Collection<?> colValue) {
        return this.resolveArraySchemaByElement(SchemaResolver.extractCollectionFirstElem(colValue), colValue.getClass().getName());
    }

    @Nullable
    private static Object extractArrayFirstElem(Object @NotNull [] array) {
        for (Object elem : array) {
            if (elem == null) continue;
            return elem;
        }
        return null;
    }

    @Nullable
    private static <E> E extractCollectionFirstElem(@NotNull Collection<E> collection) {
        for (E elem : collection) {
            if (elem == null) continue;
            return elem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Schema resolve(@NotNull String typeName, @NotNull @NotNull Supplier<@NotNull Schema> schemaProducer) {
        try {
            int recursionLevel = this.parentTypes.push(typeName);
            if (recursionLevel > 1) {
                switch (this.ctx.getRecursiveSchemaPolicy()) {
                    case ABORT: {
                        throw new SchemaBuilderException("Recursive schema for type: " + typeName + ", parents=" + this.parentTypes);
                    }
                    case ALLOW: {
                        if (recursionLevel <= this.ctx.getMaxRecursionLevel()) break;
                        throw new SchemaBuilderException("Too much recursive occurrences of type: " + typeName + ", parents=" + this.parentTypes);
                    }
                    default: {
                        log.warn(LogFormat.message(SystemEvent.KAFKA_SCHEMA_BUILD_FAILED, "Recursive schemas for type: " + typeName + ", falling back to <null> for schema and value, parents=" + this.parentTypes));
                        Schema schema = SchemaUtils.SKIP_SCHEMA;
                        return schema;
                    }
                }
            }
            Schema schema = schemaProducer.get();
            return schema;
        }
        finally {
            this.parentTypes.remove(typeName);
        }
    }

    @NotNull
    private static Schema orUndefined(@Nullable Schema schema) {
        return schema != null ? schema : SchemaUtils.UNDEFINED_SCHEMA;
    }

    private static final class ParentTypes {
        private final HashMap<String, Integer> parents = new HashMap();
        private final ArrayList<String> hierarchy = new ArrayList();

        private ParentTypes() {
        }

        @NotNull
        public Integer push(String type) {
            this.hierarchy.add(type);
            return this.parents.compute(type, (t2, count) -> count == null ? 1 : count + 1);
        }

        public void remove(String type) {
            this.hierarchy.remove(this.hierarchy.size() - 1);
            this.parents.computeIfPresent(type, (t2, count) -> count == 1 ? null : Integer.valueOf(count - 1));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append('[');
            for (int i = 0; i < this.hierarchy.size() - 1; ++i) {
                sb.append(this.hierarchy.get(i)).append(',').append(' ');
            }
            return sb.append("$type]").toString();
        }
    }
}

