/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.services.Service;
import org.apache.kafka.connect.errors.ConnectException;
import org.gridgain.kafka.LogFormat;
import org.gridgain.kafka.SystemEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.UrlResource;

public enum DataGrid implements AutoCloseable
{
    SOURCE,
    SINK;

    private final Semaphore gridLock = new Semaphore(1);
    private volatile Ignite ignite;
    private final AtomicInteger igniteClientCnt = new AtomicInteger(0);
    private static final Logger log;

    public void init(String cfgPath) {
        try {
            this.gridLock.acquire();
            if (this.ignite == null) {
                IgniteConfiguration cfg = DataGrid.createConfiguration(cfgPath, String.format("KAFKA-%s-CONNECTOR", this.name()));
                this.ignite = Ignition.start(cfg);
            }
            this.igniteClientCnt.incrementAndGet();
            log.info(LogFormat.message(SystemEvent.IGNITE_CONNECTED, "Connected to %s", this.name()));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.gridLock.release();
        }
    }

    @Override
    public void close() {
        try {
            this.gridLock.acquire();
            int cnt = this.igniteClientCnt.decrementAndGet();
            if (cnt < 0) {
                throw new IllegalStateException("DataGrid is not initialized.");
            }
            if (cnt == 0) {
                this.ignite.close();
                this.ignite = null;
                log.info(LogFormat.message(SystemEvent.IGNITE_DISCONNECTED, "Disconnected from %s", this.name()));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.gridLock.release();
        }
    }

    public Collection<String> cacheNames() {
        this.ensureInitialized();
        return this.ignite.cacheNames();
    }

    public Marshaller marshaller() {
        this.ensureInitialized();
        return this.ignite.configuration().getMarshaller();
    }

    public IgniteCache<BinaryObject, BinaryObject> cache(String name) {
        this.ensureInitialized();
        IgniteCache cache = this.ignite.cache(name);
        return cache == null ? null : cache.withKeepBinary();
    }

    public <K, V> IgniteDataStreamer<K, V> dataStreamer(String cacheName) {
        this.ensureInitialized();
        return this.ignite.dataStreamer(cacheName);
    }

    public IgniteBinary binary() {
        this.ensureInitialized();
        return this.ignite.binary();
    }

    public void deployService(String name, Service svc) {
        this.ensureInitialized();
        this.ignite.services().deployClusterSingleton(name, svc);
    }

    public void removeService(String name) {
        this.ensureInitialized();
        this.ignite.services().cancel(name);
    }

    public <T> boolean isServiceDeployed(String name, Class<? super T> cls, Consumer<T> test) {
        this.ensureInitialized();
        try {
            T svc = this.ignite.services().serviceProxy(name, cls, false);
            test.accept(svc);
            return true;
        }
        catch (IgniteException ignore) {
            return false;
        }
    }

    public void ensureCache(String name) {
        this.ensureInitialized();
        this.ignite.getOrCreateCache(name);
    }

    public IgniteConfiguration configuration() {
        this.ensureInitialized();
        return this.ignite.configuration();
    }

    public Ignite ignite() {
        this.ensureInitialized();
        return this.ignite;
    }

    private static IgniteConfiguration createConfiguration(String cfgPath, String gridName) {
        IgniteConfiguration cfg;
        if (cfgPath == null || cfgPath.isEmpty()) {
            cfg = new IgniteConfiguration();
        } else {
            URL url;
            block9: {
                url = null;
                try {
                    url = new URL(cfgPath);
                }
                catch (MalformedURLException e) {
                    File file = new File(cfgPath);
                    if (file.exists()) {
                        try {
                            url = file.toURI().toURL();
                        }
                        catch (MalformedURLException e2) {
                            throw new ConnectException(LogFormat.message(SystemEvent.MISCONFIGURATION, e2));
                        }
                    }
                    ClassLoader clsLdr = Thread.currentThread().getContextClassLoader();
                    if (clsLdr != null) {
                        url = clsLdr.getResource(cfgPath.replaceAll("\\\\", "/"));
                    }
                    if (url != null) break block9;
                    throw new ConnectException(LogFormat.message(SystemEvent.MISCONFIGURATION, "Configuration file is not found: " + e.getMessage()));
                }
            }
            cfg = new GenericXmlApplicationContext(new UrlResource(url)).getBean(IgniteConfiguration.class);
        }
        if (cfg.isClientMode() == null || !cfg.isClientMode().booleanValue()) {
            log.info(LogFormat.message(SystemEvent.RECONFIGURATION, "set client mode"));
            cfg.setClientMode(true);
        }
        cfg.setIgniteInstanceName(cfg.getIgniteInstanceName() == null ? gridName : String.format("%s-%s", cfg.getIgniteInstanceName(), gridName));
        log.info(LogFormat.message(SystemEvent.RECONFIGURATION, "set Ignite instance name to %s", cfg.getIgniteInstanceName()));
        return cfg;
    }

    private void ensureInitialized() {
        if (this.ignite == null) {
            throw new IllegalStateException(String.format("%s is not initialized.", this.name()));
        }
    }

    static {
        log = LoggerFactory.getLogger(DataGrid.class);
    }
}

