/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.kafka;

import java.util.Objects;
import javax.cache.Cache;
import org.apache.ignite.cache.query.annotations.QuerySqlField;

public final class CacheEntry
implements Cache.Entry<Object, Object> {
    @QuerySqlField
    private final Object key;
    @QuerySqlField
    private final Object val;
    @QuerySqlField(index=true)
    private final String cache;

    public CacheEntry(String cache, Cache.Entry<?, ?> entry) {
        this.cache = cache;
        if (entry != null) {
            this.key = entry.getKey();
            this.val = entry.getValue();
        } else {
            this.val = null;
            this.key = null;
        }
    }

    public CacheEntry(String cache, Object key, Object val) {
        this.cache = cache;
        this.key = key;
        this.val = val;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.val;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to class is not supported: " + cls);
    }

    public String getCache() {
        return this.cache;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CacheEntry)) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.val, other.val) && Objects.equals(this.cache, other.cache);
    }

    public int hashCode() {
        int res = 11;
        if (this.key != null) {
            res += 31 * res + this.key.hashCode();
        }
        if (this.val != null) {
            res += 31 * res + this.val.hashCode();
        }
        if (this.cache != null) {
            res += 31 * res + this.cache.hashCode();
        }
        return res;
    }

    public String toString() {
        return String.format("[%s -> %s]@%s", this.key, this.val, this.cache);
    }
}

