/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueUuid
extends Value {
    static final int PRECISION = 16;
    static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long high, long low) {
        this.high = high;
        this.low = low;
    }

    @Override
    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long high = MathUtils.secureRandomLong();
        long low = MathUtils.secureRandomLong();
        high = high & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        low = low & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(high, low);
    }

    public static ValueUuid get(byte[] binary) {
        if (binary.length < 16) {
            return ValueUuid.get(StringUtils.convertBytesToHex(binary));
        }
        long high = Bits.readLong(binary, 0);
        long low = Bits.readLong(binary, 8);
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    public static ValueUuid get(long high, long low) {
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    public static ValueUuid get(UUID uuid) {
        return ValueUuid.get(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static ValueUuid get(String s2) {
        long low = 0L;
        long high = 0L;
        int j = 0;
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                low = low << 4 | (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                low = low << 4 | (long)(c - 97 + 10);
            } else {
                if (c == '-') continue;
                if (c >= 'A' && c <= 'F') {
                    low = low << 4 | (long)(c - 65 + 10);
                } else {
                    if (c <= ' ') continue;
                    throw DbException.get(22018, s2);
                }
            }
            if (j++ != 15) continue;
            high = low;
            low = 0L;
        }
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append('\'');
        return this.addString(builder).append('\'');
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_UUID;
    }

    @Override
    public int getMemory() {
        return 32;
    }

    @Override
    public int getValueType() {
        return 20;
    }

    @Override
    public String getString() {
        return this.addString(new StringBuilder(36)).toString();
    }

    private StringBuilder addString(StringBuilder builder) {
        StringUtils.appendHex(builder, this.high >> 32, 4).append('-');
        StringUtils.appendHex(builder, this.high >> 16, 2).append('-');
        StringUtils.appendHex(builder, this.high, 2).append('-');
        StringUtils.appendHex(builder, this.low >> 48, 2).append('-');
        return StringUtils.appendHex(builder, this.low, 6);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        if (o == this) {
            return 0;
        }
        ValueUuid v = (ValueUuid)o;
        long v1 = this.high;
        long v2 = v.high;
        if (v1 == v2) {
            v1 = this.low;
            v2 = v.low;
            if (mode.isUuidUnsigned()) {
                v1 += Long.MIN_VALUE;
                v2 += Long.MIN_VALUE;
            }
            return Long.compare(v1, v2);
        }
        if (mode.isUuidUnsigned()) {
            v1 += Long.MIN_VALUE;
            v2 += Long.MIN_VALUE;
        }
        return v1 > v2 ? 1 : -1;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueUuid)) {
            return false;
        }
        ValueUuid v = (ValueUuid)other;
        return this.high == v.high && this.low == v.low;
    }

    @Override
    public Object getObject() {
        return new UUID(this.high, this.low);
    }

    @Override
    public byte[] getBytes() {
        return Bits.uuidToBytes(this.high, this.low);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBytes(parameterIndex, this.getBytes());
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }
}

