/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueTime
extends Value {
    public static final int DEFAULT_PRECISION = 8;
    public static final int MAXIMUM_PRECISION = 18;
    static final int DEFAULT_SCALE = 0;
    public static final int MAXIMUM_SCALE = 9;
    private final long nanos;

    private ValueTime(long nanos) {
        this.nanos = nanos;
    }

    public static ValueTime fromNanos(long nanos) {
        if (nanos < 0L || nanos >= 86400000000000L) {
            StringBuilder builder = new StringBuilder();
            DateTimeUtils.appendTime(builder, nanos);
            throw DbException.get(22007, "TIME", builder.toString());
        }
        return (ValueTime)ValueTime.cache(new ValueTime(nanos));
    }

    public static ValueTime get(Time time) {
        long ms = time.getTime();
        return ValueTime.fromNanos(DateTimeUtils.nanosFromLocalMillis(ms + (long)DateTimeUtils.getTimeZoneOffset(ms)));
    }

    public static ValueTime fromMillis(long ms) {
        return ValueTime.fromNanos(DateTimeUtils.nanosFromLocalMillis(ms + (long)DateTimeUtils.getTimeZoneOffset(ms)));
    }

    public static ValueTime parse(String s2) {
        try {
            return ValueTime.fromNanos(DateTimeUtils.parseTimeNanos(s2, 0, s2.length()));
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIME", s2);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public Time getTime() {
        return DateTimeUtils.convertNanoToTime(this.nanos);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIME;
    }

    @Override
    public int getValueType() {
        return 9;
    }

    @Override
    public String getString() {
        StringBuilder buff = new StringBuilder(18);
        DateTimeUtils.appendTime(buff, this.nanos);
        return buff.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append("TIME '");
        DateTimeUtils.appendTime(builder, this.nanos);
        return builder.append('\'');
    }

    @Override
    public boolean checkPrecision(long precision) {
        return true;
    }

    @Override
    public Value convertScale(boolean onlyToSmallerScale, int targetScale) {
        if (targetScale >= 9) {
            return this;
        }
        if (targetScale < 0) {
            throw DbException.getInvalidValueException("scale", targetScale);
        }
        long n = this.nanos;
        long n2 = DateTimeUtils.convertScale(n, targetScale);
        if (n2 == n) {
            return this;
        }
        if (n2 >= 86400000000000L) {
            n2 = 86399999999999L;
        }
        return ValueTime.fromNanos(n2);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Long.compare(this.nanos, ((ValueTime)o).nanos);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ValueTime && this.nanos == ((ValueTime)other).nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTime();
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setTime(parameterIndex, this.getTime());
    }

    @Override
    public Value add(Value v) {
        ValueTime t2 = (ValueTime)v.convertTo(9);
        return ValueTime.fromNanos(this.nanos + t2.getNanos());
    }

    @Override
    public Value subtract(Value v) {
        ValueTime t2 = (ValueTime)v.convertTo(9);
        return ValueTime.fromNanos(this.nanos - t2.getNanos());
    }

    @Override
    public Value multiply(Value v) {
        return ValueTime.fromNanos((long)((double)this.nanos * v.getDouble()));
    }

    @Override
    public Value divide(Value v) {
        return ValueTime.fromNanos((long)((double)this.nanos / v.getDouble()));
    }
}

